/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.connection.helper;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.suncode.plugin.ftp.file.modifier.FileNameModifier;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileOperationUtils {
    private static final Logger log = LoggerFactory.getLogger(FileOperationUtils.class);

    private FileOperationUtils() {
    }

    public static String getDirectoryPathFromPath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        String normalizedPath = FilenameUtils.separatorsToUnix((String)filePath);
        String fullPath = FilenameUtils.getFullPath((String)normalizedPath);
        String result = fullPath.endsWith("/") && fullPath.length() > 1 ? fullPath.substring(0, fullPath.length() - 1) : fullPath;
        return FilenameUtils.separatorsToUnix((String)result);
    }

    public static String buildDestinationPath(String moveRemoteDirPath, String fileName, String rootFtpDirectory) throws IOException {
        if (StringUtils.isBlank((CharSequence)moveRemoteDirPath) || StringUtils.isBlank((CharSequence)fileName)) {
            return "";
        }
        Path path = Paths.get(rootFtpDirectory, moveRemoteDirPath, fileName);
        return FilenameUtils.separatorsToUnix((String)path.toFile().getCanonicalPath());
    }

    public static boolean checkIfFileExists(FTPClient client, String filePath) {
        try {
            FTPFile[] files = client.listFiles(filePath);
            return files != null && files.length > 0;
        }
        catch (IOException e) {
            log.warn("Error checking file existence: " + filePath, (Throwable)e);
            return false;
        }
    }

    public static Set<String> loadExistingFileNames(FTPClient client, String directoryPath) {
        HashSet<String> existingFileNames = new HashSet<String>();
        try {
            FTPFile[] files = client.listFiles(directoryPath);
            if (files != null) {
                for (FTPFile file : files) {
                    if (file.isDirectory()) continue;
                    existingFileNames.add(file.getName());
                }
            }
        }
        catch (IOException e) {
            log.warn("Could not list files in directory: " + directoryPath, (Throwable)e);
        }
        return existingFileNames;
    }

    public static boolean checkIfFileExists(ChannelSftp channelSftp, String filePath) {
        try {
            channelSftp.lstat(filePath);
            return true;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return false;
            }
            throw new RuntimeException("Error checking file existence: " + filePath, e);
        }
    }

    public static Set<String> loadExistingFileNames(ChannelSftp channelSftp, String directoryPath) {
        HashSet<String> existingFileNames = new HashSet<String>();
        try {
            Vector files = channelSftp.ls(directoryPath);
            for (ChannelSftp.LsEntry file : files) {
                if (file.getAttrs().isDir()) continue;
                existingFileNames.add(file.getFilename());
            }
        }
        catch (SftpException e) {
            log.warn("Could not list files in directory: " + directoryPath, (Throwable)e);
        }
        return existingFileNames;
    }

    public static String handleExistingFile(Set<String> existingFileNames, String fullPath) throws IOException {
        String fileName = FileOperationUtils.getFileNameFromPath(fullPath);
        String directoryPath = FileOperationUtils.getDirectoryPathFromPath(fullPath);
        FileNameModifier fileNameModifier = new FileNameModifier(existingFileNames);
        String newFileName = fileNameModifier.changeFileName(fileName);
        String destinationPath = FileOperationUtils.buildDestinationPath(directoryPath, newFileName, "");
        log.info(MessageFormat.format("File \"{0}\" already exists, renamed to \"{1}\".", fileName, newFileName));
        return destinationPath;
    }

    private static String getFileNameFromPath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return "";
        }
        String normalizedPath = FilenameUtils.separatorsToUnix((String)filePath);
        String result = FilenameUtils.getName((String)normalizedPath);
        return FilenameUtils.separatorsToUnix((String)result);
    }
}

