/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.connection.filter;

import lombok.NonNull;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;

public class LatestFTPFileFilter
implements FTPFileFilter {
    private final Long latestFileTime;

    public LatestFTPFileFilter(@NonNull Long latestFileTime) {
        if (latestFileTime == null) {
            throw new NullPointerException("latestFileTime");
        }
        this.latestFileTime = latestFileTime;
    }

    public boolean accept(FTPFile file) {
        return file.isFile() && file.getTimestamp().getTimeInMillis() > this.latestFileTime;
    }
}

