/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.connection;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.suncode.plugin.ftp.configuration.dto.ConnectionConfigurationDto;
import com.suncode.plugin.ftp.connection.ClientConnection;
import com.suncode.plugin.ftp.connection.helper.FileOperationUtils;
import com.suncode.plugin.ftp.dto.DownloadedFileDto;
import com.suncode.plugin.ftp.dto.FileToSendDto;
import com.suncode.plugin.ftp.exception.FTPClientConnectionException;
import com.suncode.plugin.ftp.exception.FTPClientDeleteFileException;
import com.suncode.plugin.ftp.exception.FTPClientDownloadException;
import com.suncode.plugin.ftp.exception.FTPClientInvalidLocalDirectoryException;
import com.suncode.plugin.ftp.exception.FTPClientInvalidWorkingDirectoryException;
import com.suncode.plugin.ftp.exception.FTPClientSaveException;
import com.suncode.plugin.ftp.file.modifier.FileNameModifier;
import com.suncode.pwfl.archive.FileService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPClientConnection
implements ClientConnection {
    private static final Logger log = LoggerFactory.getLogger(SFTPClientConnection.class);
    private final FileService fileService;
    private Session session;
    private ChannelSftp channelSftp;
    private int numberOfCreatedFiles = 0;
    private int numberOfCreatedDirectories = 0;

    public SFTPClientConnection(FileService fileService) {
        this.fileService = fileService;
    }

    private void setupSftpConnection(ConnectionConfigurationDto connectionConfiguration) {
        log.debug("Attempting to connect to the server with the address '" + connectionConfiguration.getServerAddress() + "' and port '" + connectionConfiguration.getPortNumber() + "'");
        JSch jsch = new JSch();
        int portNumber = connectionConfiguration.getPortNumber().intValue();
        try {
            this.session = jsch.getSession(connectionConfiguration.getUserName(), connectionConfiguration.getServerAddress(), portNumber);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setPassword(connectionConfiguration.getPassword());
            this.session.connect();
            this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
            this.channelSftp.connect();
            log.debug("sFtp pwd after connect : " + this.channelSftp.pwd());
            log.debug("Successfully connected and logged in to the server");
        }
        catch (JSchException e) {
            String msg = "An error occurred while trying to connect to the server with address " + connectionConfiguration.getServerAddress() + " and port " + connectionConfiguration.getPortNumber();
            FTPClientConnectionException fcce = new FTPClientConnectionException(msg, e);
            fcce.setTranslatorKey("connection-exception.ftp-client.error-message");
            throw fcce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendFilesToServer(ConnectionConfigurationDto connectionConfiguration, Map<String, List<FileToSendDto>> allFilesToSend) {
        try {
            DateTime startTime = DateTime.now();
            this.setupSftpConnection(connectionConfiguration);
            String rootPath = this.channelSftp.pwd();
            for (String pathName : allFilesToSend.keySet()) {
                List<FileToSendDto> filesToSend = allFilesToSend.get(pathName);
                for (FileToSendDto fileToSend : filesToSend) {
                    try {
                        InputStream stream = this.fileService.getFileInputStream(fileToSend.getFileId());
                        Throwable throwable = null;
                        try {
                            this.createDirectoriesOnSftpServer(fileToSend.getFilePath());
                            this.channelSftp.put(stream, fileToSend.getFileName(), 0);
                            this.channelSftp.cd(rootPath);
                            ++this.numberOfCreatedFiles;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        String msg = "An error occurred while trying to save the file '" + fileToSend.getOriginalFileName() + "' to the server. " + this.numberOfCreatedFiles + " files and " + this.numberOfCreatedDirectories + " directories have been created";
                        FTPClientSaveException fcse = new FTPClientSaveException(msg, e);
                        fcse.setTranslatorKey("save-exception.ftp-client.error-message");
                        fcse.setOrginalFileName(fileToSend.getOriginalFileName());
                        fcse.setNumberOfCreatedFiles(this.numberOfCreatedFiles);
                        fcse.setNumberOfCreatedCategories(this.numberOfCreatedDirectories);
                        throw fcse;
                    }
                }
            }
            DateTime endTime = DateTime.now();
            Interval interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            float seconds = (float)interval.toDurationMillis() / 1000.0f;
            log.debug(this.numberOfCreatedFiles + " files and " + this.numberOfCreatedDirectories + " directories have been created in " + seconds + " seconds during this server connection");
        }
        finally {
            if (this.channelSftp != null) {
                this.channelSftp.exit();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
    }

    private void createDirectoriesOnSftpServer(String filePath) {
        String[] directories;
        for (String directory : directories = filePath.split("/")) {
            if (StringUtils.isBlank((CharSequence)directory)) continue;
            try {
                this.channelSftp.cd(directory);
            }
            catch (SftpException e) {
                this.channelSftp.mkdir(directory);
                this.channelSftp.cd(directory);
                ++this.numberOfCreatedDirectories;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDirectoryExists(String directoryPath) throws SftpException {
        String originalPath = this.channelSftp.pwd();
        try {
            this.channelSftp.cd(directoryPath);
            return;
        }
        catch (SftpException e) {
            if (e.id != 2) {
                throw e;
            }
            log.info("Directory path \"{}\" does not exist. Creating missing directories...", (Object)directoryPath);
            boolean isPathAbsolute = directoryPath.startsWith("/");
            if (isPathAbsolute) {
                this.channelSftp.cd("/");
            }
            for (String directory : directoryPath.split("/")) {
                if (StringUtils.isBlank((CharSequence)directory)) continue;
                try {
                    this.channelSftp.cd(directory);
                }
                catch (SftpException e2) {
                    if (e2.id != 2) {
                        throw e2;
                    }
                    log.info("Creating directory: {}", (Object)directory);
                    this.channelSftp.mkdir(directory);
                    this.channelSftp.cd(directory);
                    ++this.numberOfCreatedDirectories;
                }
            }
        }
        finally {
            this.channelSftp.cd(originalPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadedFileDto> downloadFilesFromServer(String localDirPath, String remoteDirPath, boolean deleteRemoteFile, boolean moveRemoteFiles, String moveRemoteDirPath, boolean overwriteMovedFiles, ConnectionConfigurationDto connectionConfiguration, boolean overwriteFiles, Timestamp latestModificationTime) {
        LinkedList<DownloadedFileDto> linkedList;
        block10: {
            try {
                this.setupSftpConnection(connectionConfiguration);
                String rootFtpDirectory = this.channelSftp.pwd();
                try {
                    this.channelSftp.cd(remoteDirPath);
                }
                catch (SftpException e) {
                    throw new FTPClientInvalidWorkingDirectoryException(remoteDirPath);
                }
                FileNameModifier fileNameModifier = new FileNameModifier(this.loadExistingFileNames(localDirPath));
                LinkedList<DownloadedFileDto> downloadedFiles = new LinkedList<DownloadedFileDto>();
                Vector<ChannelSftp.LsEntry> files = new Vector<ChannelSftp.LsEntry>();
                this.channelSftp.ls("*", entry -> {
                    if (!entry.getAttrs().isDir() && (long)entry.getAttrs().getMTime() > latestModificationTime.getTime()) {
                        files.add(entry);
                    }
                    return 0;
                });
                files.forEach(file -> {
                    DownloadedFileDto downloadedFileDto = DownloadedFileDto.builder().remoteFileModificationTime(Long.valueOf(file.getAttrs().getMTime())).name(overwriteFiles ? file.getFilename() : fileNameModifier.changeFileName(file.getFilename())).remoteFileName(file.getFilename()).localDirPath(localDirPath).remoteDirPath(remoteDirPath).size(file.getAttrs().getSize()).deletedRemoteFile(false).movedRemoteFile(false).build();
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(localDirPath + File.separator + downloadedFileDto.getName()));){
                        this.downloadFileFromSftpServer(deleteRemoteFile, moveRemoteFiles, moveRemoteDirPath, overwriteMovedFiles, downloadedFiles, downloadedFileDto, outputStream, rootFtpDirectory);
                    }
                    catch (Exception e) {
                        throw new FTPClientDownloadException(downloadedFileDto.getRemoteFileName(), e);
                    }
                });
                linkedList = downloadedFiles;
                if (this.channelSftp == null) break block10;
            }
            catch (Throwable throwable) {
                if (this.channelSftp != null) {
                    this.channelSftp.exit();
                }
                if (this.session != null) {
                    this.session.disconnect();
                }
                throw throwable;
            }
            this.channelSftp.exit();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        return linkedList;
    }

    private Set<String> loadExistingFileNames(String localDirPath) {
        File file = FileUtils.getFile((String[])new String[]{localDirPath});
        if (file == null || !file.exists()) {
            throw new FTPClientInvalidLocalDirectoryException(localDirPath, "Path does not exist");
        }
        if (!file.isDirectory()) {
            throw new FTPClientInvalidLocalDirectoryException(localDirPath, "Path is not a directory");
        }
        if (!file.canRead()) {
            throw new FTPClientInvalidLocalDirectoryException(localDirPath, "No read rights to the directory");
        }
        File[] files = file.listFiles();
        if (files == null) {
            throw new FTPClientInvalidLocalDirectoryException(localDirPath, "I/O error occurred while reading directory");
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toSet());
    }

    private void downloadFileFromSftpServer(boolean deleteRemoteFile, boolean moveRemoteFiles, String moveRemoteDirPath, boolean overwriteMovedFiles, List<DownloadedFileDto> downloadedFiles, DownloadedFileDto downloadedFileDto, OutputStream outputStream, String rootFtpDirectory) {
        this.channelSftp.get(downloadedFileDto.getRemoteFileName(), outputStream);
        log.debug("File '" + downloadedFileDto.getRemoteFileName() + "' has been downloaded successfully.");
        if (deleteRemoteFile && !moveRemoteFiles) {
            this.deleteFileOnSftpServer(downloadedFileDto);
        } else if (moveRemoteFiles) {
            this.moveFileOnSftpServer(downloadedFileDto, moveRemoteDirPath, overwriteMovedFiles, rootFtpDirectory);
        }
        downloadedFiles.add(downloadedFileDto);
    }

    private void deleteFileOnSftpServer(DownloadedFileDto downloadedFileDto) {
        try {
            this.channelSftp.rm(downloadedFileDto.getRemoteFileName());
            log.debug("The file '" + downloadedFileDto.getRemoteFileName() + "' was deleted successfully.");
            downloadedFileDto.setDeletedRemoteFile(true);
        }
        catch (SftpException e) {
            FTPClientDeleteFileException remoteDeleteFileException = new FTPClientDeleteFileException(downloadedFileDto.getRemoteFileName(), e);
            downloadedFileDto.setException(remoteDeleteFileException);
            log.warn(remoteDeleteFileException.getMessage(), (Throwable)remoteDeleteFileException);
        }
    }

    private void moveFileOnSftpServer(DownloadedFileDto downloadedFileDto, String moveRemoteDirPath, boolean overwriteMovedFiles, String rootFtpDirectory) throws SftpException, IOException {
        String destinationDirectoryPath;
        String destinationPath = FileOperationUtils.buildDestinationPath(moveRemoteDirPath, downloadedFileDto.getRemoteFileName(), rootFtpDirectory);
        boolean fileExistInDestinationPath = FileOperationUtils.checkIfFileExists(this.channelSftp, destinationPath);
        if (fileExistInDestinationPath) {
            if (overwriteMovedFiles) {
                this.channelSftp.rm(destinationPath);
            } else {
                String directoryPath = FileOperationUtils.getDirectoryPathFromPath(destinationPath);
                Set<String> existingFileNames = FileOperationUtils.loadExistingFileNames(this.channelSftp, directoryPath);
                destinationPath = FileOperationUtils.handleExistingFile(existingFileNames, destinationPath);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(destinationDirectoryPath = FileOperationUtils.getDirectoryPathFromPath(destinationPath)))) {
            try {
                this.ensureDirectoryExists(destinationDirectoryPath);
            }
            catch (Exception e) {
                log.error(MessageFormat.format("Failed to create destination directory \"{0}\": {1}", destinationDirectoryPath, e.getMessage()), (Throwable)e);
                throw new IOException("Failed to create destination directory: " + destinationDirectoryPath, e);
            }
        }
        String sourcePath = downloadedFileDto.getRemoteFileName();
        log.debug("Current working directory (PWD): " + this.channelSftp.pwd());
        log.debug(MessageFormat.format("Moved from \"{0}\" to \"{1}\".", sourcePath, destinationPath));
        this.channelSftp.rename(sourcePath, destinationPath);
        log.info(MessageFormat.format("The file \"{0}\" was moved successfully to \"{1}\".", sourcePath, destinationPath));
        downloadedFileDto.setMovedRemoteFile(true);
    }
}

