/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.connection;

import com.suncode.plugin.ftp.configuration.dto.ConnectionConfigurationDto;
import com.suncode.plugin.ftp.connection.ClientConnection;
import com.suncode.plugin.ftp.connection.filter.LatestFTPFileFilter;
import com.suncode.plugin.ftp.connection.helper.FileOperationUtils;
import com.suncode.plugin.ftp.dto.DownloadedFileDto;
import com.suncode.plugin.ftp.dto.FileToSendDto;
import com.suncode.plugin.ftp.exception.FTPClientConnectionException;
import com.suncode.plugin.ftp.exception.FTPClientDeleteFileException;
import com.suncode.plugin.ftp.exception.FTPClientDownloadException;
import com.suncode.plugin.ftp.exception.FTPClientInvalidWorkingDirectoryException;
import com.suncode.plugin.ftp.exception.FTPClientSaveException;
import com.suncode.plugin.ftp.file.modifier.FileNameModifier;
import com.suncode.pwfl.archive.FileService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientConnection
implements ClientConnection {
    private static final Logger log = LoggerFactory.getLogger(FTPClientConnection.class);
    private final FTPClient client;
    private final FileService fileService;
    private int numberOfCreatedFiles = 0;
    private int numberOfCreatedDirectories = 0;

    public FTPClientConnection(FTPClient client, FileService fileService) {
        this.client = client;
        this.fileService = fileService;
    }

    private void initConnection(ConnectionConfigurationDto connectionConfiguration) {
        try {
            log.debug("Attempting to connect to the server with the address '" + connectionConfiguration.getServerAddress() + "' and port '" + connectionConfiguration.getPortNumber() + "'");
            this.client.setAutodetectUTF8(true);
            int integerPortNumber = connectionConfiguration.getPortNumber().intValue();
            this.client.connect(connectionConfiguration.getServerAddress(), integerPortNumber);
            this.client.enterLocalPassiveMode();
            if (!this.client.login(connectionConfiguration.getUserName(), connectionConfiguration.getPassword())) {
                String msg = "Server code status: " + this.client.getReplyString();
                FTPClientConnectionException ftpClientConnectionException = new FTPClientConnectionException(msg);
                ftpClientConnectionException.setTranslatorKey("connection-exception.ftp-client.error-message");
                throw ftpClientConnectionException;
            }
            log.debug("Successfully connected and logged in to the server");
        }
        catch (IOException ioe) {
            String msg = "An error occurred while trying to connect to the server with address " + connectionConfiguration.getServerAddress() + " and port " + connectionConfiguration.getPortNumber();
            FTPClientConnectionException fcce = new FTPClientConnectionException(msg, ioe);
            fcce.setTranslatorKey("connection-exception.ftp-client.error-message");
            throw fcce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendFilesToServer(ConnectionConfigurationDto connectionConfiguration, Map<String, List<FileToSendDto>> allFilesToSend) {
        try {
            DateTime startTime = DateTime.now();
            this.initConnection(connectionConfiguration);
            String rootPath = this.client.printWorkingDirectory();
            for (String pathName : allFilesToSend.keySet()) {
                List<FileToSendDto> filesToSend = allFilesToSend.get(pathName);
                for (FileToSendDto fileToSend : filesToSend) {
                    try {
                        InputStream stream = this.fileService.getFileInputStream(fileToSend.getFileId());
                        Throwable throwable = null;
                        try {
                            String filePath = rootPath + fileToSend.getFilePath();
                            this.client.setFileType(2);
                            this.createDirectories(filePath);
                            this.client.changeWorkingDirectory(filePath);
                            if (!this.client.storeFile(fileToSend.getFileName(), stream)) {
                                throw new IOException("The file '" + fileToSend.getFileName() + "' could not be created");
                            }
                            ++this.numberOfCreatedFiles;
                        }
                        catch (Throwable filePath) {
                            throwable = filePath;
                            throw filePath;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable filePath) {
                                    throwable.addSuppressed(filePath);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (IOException ioe) {
                        String msg = "An error occurred while trying to save the file '" + fileToSend.getOriginalFileName() + "' to the server. " + this.numberOfCreatedFiles + " files and " + this.numberOfCreatedDirectories + " directories have been created";
                        FTPClientSaveException fcse = new FTPClientSaveException(msg, ioe);
                        fcse.setTranslatorKey("save-exception.ftp-client.error-message");
                        fcse.setOrginalFileName(fileToSend.getOriginalFileName());
                        fcse.setNumberOfCreatedFiles(this.numberOfCreatedFiles);
                        fcse.setNumberOfCreatedCategories(this.numberOfCreatedDirectories);
                        throw fcse;
                    }
                }
            }
            DateTime endTime = DateTime.now();
            Interval interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            float seconds = (float)interval.toDurationMillis() / 1000.0f;
            log.debug(this.numberOfCreatedFiles + " files and " + this.numberOfCreatedDirectories + " directories have been created in " + seconds + " seconds during this server connection");
            this.client.logout();
        }
        finally {
            this.client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadedFileDto> downloadFilesFromServer(String localDirPath, String remoteDirPath, boolean deleteRemoteFile, boolean moveRemoteFiles, String moveRemoteDirPath, boolean overwriteMovedFiles, ConnectionConfigurationDto connectionConfiguration, boolean overwriteFiles, Timestamp latestModificationTime) {
        LinkedList<DownloadedFileDto> linkedList;
        try {
            this.initConnection(connectionConfiguration);
            this.client.setFileType(2);
            String rootFtpDirectory = this.client.printWorkingDirectory();
            if (!this.client.changeWorkingDirectory(remoteDirPath)) {
                throw new FTPClientInvalidWorkingDirectoryException(remoteDirPath);
            }
            FileNameModifier fileNameModifier = new FileNameModifier(this.loadExistingFileNames(localDirPath));
            LinkedList<DownloadedFileDto> downloadedFiles = new LinkedList<DownloadedFileDto>();
            List<FTPFile> files = Arrays.asList(this.client.listFiles(null, (FTPFileFilter)new LatestFTPFileFilter(latestModificationTime.getTime())));
            files.forEach(file -> {
                DownloadedFileDto downloadedFileDto = DownloadedFileDto.builder().remoteFileModificationTime(file.getTimestamp().getTimeInMillis()).name(overwriteFiles ? file.getName() : fileNameModifier.changeFileName(file.getName())).remoteFileName(file.getName()).localDirPath(localDirPath).remoteDirPath(remoteDirPath).size(file.getSize()).deletedRemoteFile(false).movedRemoteFile(false).build();
                try (BufferedOutputStream outputStream1 = new BufferedOutputStream(new FileOutputStream(localDirPath + File.separator + downloadedFileDto.getName()));){
                    this.downloadFileFromFtpServer(deleteRemoteFile, moveRemoteFiles, moveRemoteDirPath, overwriteMovedFiles, downloadedFiles, downloadedFileDto, outputStream1, rootFtpDirectory);
                }
                catch (Exception e) {
                    throw new FTPClientDownloadException(downloadedFileDto.getRemoteFileName(), e);
                }
            });
            linkedList = downloadedFiles;
        }
        catch (Throwable throwable) {
            this.client.disconnect();
            throw throwable;
        }
        this.client.disconnect();
        return linkedList;
    }

    private Set<String> loadExistingFileNames(String localDirPath) {
        File file = FileUtils.getFile((String[])new String[]{localDirPath});
        if (file == null) {
            return new HashSet<String>();
        }
        return Arrays.stream(file.listFiles()).map(File::getName).collect(Collectors.toSet());
    }

    private void downloadFileFromFtpServer(boolean deleteRemoteFile, boolean moveRemoteFiles, String moveRemoteDirPath, boolean overwriteMovedFiles, List<DownloadedFileDto> downloadedFiles, DownloadedFileDto downloadedFileDto, OutputStream outputStream1, String rootFtpDirectory) {
        if (this.client.retrieveFile(downloadedFileDto.getRemoteFileName(), outputStream1)) {
            log.debug("File '" + downloadedFileDto.getRemoteFileName() + "' has been downloaded successfully.");
            if (deleteRemoteFile && !moveRemoteFiles) {
                this.deleteFileOnFtpServer(downloadedFileDto);
            } else if (moveRemoteFiles) {
                this.moveFileOnFtpServer(downloadedFileDto, moveRemoteDirPath, overwriteMovedFiles, rootFtpDirectory);
            }
            downloadedFiles.add(downloadedFileDto);
        }
    }

    private void deleteFileOnFtpServer(DownloadedFileDto downloadedFileDto) {
        try {
            if (this.client.deleteFile(downloadedFileDto.getRemoteFileName())) {
                log.debug("The file '" + downloadedFileDto.getRemoteFileName() + "' was deleted successfully.");
                downloadedFileDto.setDeletedRemoteFile(true);
            } else {
                FTPClientDeleteFileException remoteDeleteFileException = new FTPClientDeleteFileException(downloadedFileDto.getRemoteFileName());
                downloadedFileDto.setException(remoteDeleteFileException);
                log.warn(remoteDeleteFileException.getMessage(), (Throwable)remoteDeleteFileException);
            }
        }
        catch (Exception e) {
            FTPClientDeleteFileException remoteDeleteFileException = new FTPClientDeleteFileException(downloadedFileDto.getRemoteFileName(), e);
            downloadedFileDto.setException(remoteDeleteFileException);
            log.warn(remoteDeleteFileException.getMessage(), (Throwable)remoteDeleteFileException);
        }
    }

    private void moveFileOnFtpServer(DownloadedFileDto downloadedFileDto, String moveRemoteDirPath, boolean overwriteMovedFiles, String rootFtpDirectory) throws IOException {
        String destinationPath = FileOperationUtils.buildDestinationPath(moveRemoteDirPath, downloadedFileDto.getRemoteFileName(), rootFtpDirectory);
        boolean fileExistInDestinationPath = FileOperationUtils.checkIfFileExists(this.client, destinationPath);
        if (fileExistInDestinationPath) {
            if (overwriteMovedFiles) {
                if (!this.client.deleteFile(destinationPath)) {
                    throw new IOException(MessageFormat.format("Could not delete existing file \"{0}\" for overwrite", destinationPath));
                }
            } else {
                String directoryPath = FileOperationUtils.getDirectoryPathFromPath(destinationPath);
                Set<String> existingFileNames = FileOperationUtils.loadExistingFileNames(this.client, directoryPath);
                destinationPath = FileOperationUtils.handleExistingFile(existingFileNames, destinationPath);
            }
        }
        String sourcePath = downloadedFileDto.getRemoteFileName();
        log.debug("Current working directory (PWD): " + this.client.printWorkingDirectory());
        log.info(MessageFormat.format("Moved from \"{0}\" to \"{1}\".", sourcePath, destinationPath));
        if (!this.client.rename(sourcePath, destinationPath)) {
            throw new IOException(MessageFormat.format("Could not move file \"{0}\" to \"{1}\"", sourcePath, destinationPath));
        }
        log.info(MessageFormat.format("The file \"{0}\" was moved successfully to \"{1}\".", sourcePath, destinationPath));
        downloadedFileDto.setMovedRemoteFile(true);
    }

    private void createDirectories(String filePath) throws IOException {
        StringBuilder builder = new StringBuilder();
        String[] path = filePath.split("/");
        String tempDirectoryPath = this.client.printWorkingDirectory();
        for (String s : path) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            builder.append("/").append(s);
            if (!this.client.changeWorkingDirectory(builder.toString())) {
                this.client.changeWorkingDirectory(tempDirectoryPath);
                if (!this.client.makeDirectory(s)) {
                    throw new IOException("The directory '" + builder + "' could not be created");
                }
                ++this.numberOfCreatedDirectories;
            }
            tempDirectoryPath = builder.toString();
        }
    }
}

