/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.configuration.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.ftp.configuration.dto.ConnectionConfigurationDto;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FtpConfigurationService {
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    public ConnectionConfigurationDto getConfigurationFromPCM(String configId) throws IOException {
        ConnectionConfigurationDto connectionConfiguration = this.readServerConfiguration(configId);
        this.validateConfiguration(connectionConfiguration);
        return connectionConfiguration;
    }

    private ConnectionConfigurationDto readServerConfiguration(String configId) throws IOException {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);){
            String configuration = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            ConnectionConfigurationDto connectionConfigurationDto = (ConnectionConfigurationDto)this.mapper.readValue(configuration, ConnectionConfigurationDto.class);
            return connectionConfigurationDto;
        }
    }

    private void validateConfiguration(ConnectionConfigurationDto connectionConfiguration) {
        Assert.notNull((Object)connectionConfiguration.getServerAddress(), (String)"serverAddress cannot be null");
        Assert.notNull((Object)connectionConfiguration.getPortNumber(), (String)"portNumber cannot be null");
        Assert.notNull((Object)connectionConfiguration.getUserName(), (String)"userName cannot be null");
        Assert.notNull((Object)connectionConfiguration.getPassword(), (String)"password cannot be null");
        Assert.notNull((Object)((Object)connectionConfiguration.getProtocol()), (String)"protocol cannot be null");
    }
}

