/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.ftp.file.modifier;

import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameModifier {
    private static final Logger log = LoggerFactory.getLogger(FileNameModifier.class);
    private final Set<String> existingFileNames;

    public FileNameModifier(@NonNull Set<String> existingFileNames) {
        if (existingFileNames == null) {
            throw new NullPointerException("existingFileNames");
        }
        log.debug("Constructor");
        this.existingFileNames = existingFileNames;
    }

    public String changeFileName(String fileName) {
        String newFileName = fileName;
        int i = 1;
        while (!this.existingFileNames.add(newFileName)) {
            newFileName = this.addDigitToExistingFile(i, fileName);
            ++i;
        }
        return newFileName;
    }

    private String addDigitToExistingFile(int digit, String fileName) {
        CharSequence[] fileNameParts = fileName.split("\\.");
        if (fileNameParts.length == 1 || fileNameParts.length == 2 && StringUtils.isBlank((CharSequence)fileNameParts[0])) {
            int n = fileNameParts.length - 1;
            fileNameParts[n] = fileNameParts[n] + " (" + digit + ")";
        } else {
            int n = fileNameParts.length - 2;
            fileNameParts[n] = fileNameParts[n] + " (" + digit + ")";
        }
        return String.join((CharSequence)".", fileNameParts);
    }
}

