window.ESignature = {
    t: PW.I18N.createT("com.suncode.plugin-plus-esignature"),

    addFilesDownloadingSourceList: function(idName, listenersFn, form, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/document/filesDownloadingSource",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "value",
                        type: "string"
                    }
                ]
            },
            valueField: "value",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addComboboxClassList: function (idName, listenersFn, form, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/document/docClasses",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    }
                ]
            },
            valueField: "name",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addComboboxClassIndexList: function(idName, documentClassName, form, position) {
        if (documentClassName != undefined) {
            form.addCombobox({
                id: idName,
                remote: {
                    url: "plugin/com.suncode.plugin-plus-esignature/document/documentClassIndexList/" + documentClassName,
                    fields: [
                        {
                            name: "name",
                            type: "string"
                        },
                        {
                            name: "type",
                            type: "string"
                        }
                    ]
                },
                template: [
                    {
                        label: ESignature.t("esignature.sign-documents-action.document-class-index.name"),
                        field: "name"
                    },
                    {
                        label: ESignature.t("esignature.sign-documents-action.document-class-index.type"),
                        field: "type"
                    }
                ],
                valueField: "name",
                displayField: "name",
                sort: [{
                    property: "name",
                    direction: "ASC"
                }]
            }, position);
        }
        else {
            form.addField({
                id: idName,
                listeners: listenersFn
            }, position);
        }
    },


    addComboboxClassIndexListBasedOnDocumentClassRow: function(idName, documentClassesParameterId, form, parentForm, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: function(options, formObject = parentForm) {
                    return "plugin/com.suncode.plugin-plus-esignature/document/documentClassIndexList/"
                        + formObject.getValue(documentClassesParameterId)[options.rowIndex];
                },
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "type",
                        type: "string"
                    }]
            },
            template: [
                {
                    label: ESignature.t("esignature.sign-documents-action.document-class-index.name"),
                    field: "name"
                },
                {
                    label: ESignature.t("esignature.sign-documents-action.document-class-index.type"),
                    field: "type"
                }],
            valueField: "name",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }]
        }, position);
    },

    clearColumnValues: function(id, form) {
        for (let rowIndex = 0; rowIndex < form.getArraySize(id); rowIndex++) {
            form.setFieldValueInArray(id, rowIndex, "");
        }
    },

    clearColumnRowValue: function(form, parameterId, rowIndex) {
        form.setFieldValueInArray(parameterId, rowIndex, "");
    },

    addComboboxConfigurationList : function(idName, form, position){
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/config/configurationFiles",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    }
                ]
            },
            template: [
                {
                    label: ESignature.t("esignature.sign-documents-action.certificate-file.name"),
                    field: "name"
                }
            ],
            valueField: "name",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
        }, position)
    },

    addComboboxSignatureVersionList: function (idName, listenersFn, form, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/signature/versions",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "value",
                        type: "string"
                    }
                ]
            },
            valueField: "value",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addComboboxSignatureFormatList: function (idName, listenersFn, signatureVersion, form, position, optionalParam) {
        form.addCombobox({
            id: idName,
            optional: optionalParam,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/signature/formats/" + signatureVersion,
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "value",
                        type: "string"
                    }
                ]
            },
            valueField: "value",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addComboboxAllSignatureFormatList: function (idName, listenersFn, form, position, optionalParam) {
        form.addCombobox({
            id: idName,
            optional: optionalParam,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/signature/allFormats",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "value",
                        type: "string"
                    }
                ]
            },
            valueField: "value",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }],
            listeners: listenersFn
        }, position);
    },

    addSavingSigningInformationModeList: function(idName, form, position) {
        form.addCombobox({
            id: idName,
            remote: {
                url: "plugin/com.suncode.plugin-plus-esignature/document/savingSigningInformationMode",
                fields: [
                    {
                        name: "name",
                        type: "string"
                    },
                    {
                        name: "value",
                        type: "string"
                    }
                ]
            },
            valueField: "value",
            displayField: "name",
            sort: [{
                property: "name",
                direction: "ASC"
            }]
        }, position);
    }
}