PWE.integrationComponent.registerFormAction('esignature.sign-documents-action', {
    apiVersion: 2,
    buildForm: function(form) {
        buildForm(form);
    },
    validateForm: function(api) {
        if (api.getValue("filesDownloadingSource") === "PROCESS" || api.getValue("filesDownloadingSource") === "FILEIDS" ||
            api.hasVariableValue("filesDownloadingSource") || api.hasFunctionValue("filesDownloadingSource")) {
            if (!(validateProcessAndFileIdsSourceDocumentClasses(api) && validateProcessAndFileIdsDocumentClassIndexMappingTable(api))) {
                return false;
            }
        }
        if (api.getValue("automaticInsertionOfGraphicElement") || api.hasVariableValue("automaticInsertionOfGraphicElement") ||
            api.hasFunctionValue("automaticInsertionOfGraphicElement")) {
            return validateGraphicElementCoordinates(api);
        }
    }
});

function buildForm(form) {
    addDownloadingAndSavingFilesSettings(form);
    addSignatureSettings(form);
}

function addDownloadingAndSavingFilesSettings(form) {
    let downloadingAndSavingFilesSettings = form.addFieldSet({
        id: "downloading-and-saving-files-settings-fs",
        collapsible: true,
        collapsed: false,
        title: ESignature.t("esignature.sign-documents-action.downloading-and-saving-files-settings")
    });
    ESignature.addFilesDownloadingSourceList("filesDownloadingSource", {
        change: function(value) {
            if (value === "PROCESS") {
                toggleFieldsWhenFilesDownloadingSourceIsProcess(downloadingAndSavingFilesSettings);
            } else if (value === "ARCHIVE") {
                toggleFieldsWhenFilesDownloadingSourceIsArchive(downloadingAndSavingFilesSettings);
            } else if (value === "FILEIDS") {
                toggleFieldsWhenFilesDownloadingSourceIsFileIds(downloadingAndSavingFilesSettings);
            } else if (downloadingAndSavingFilesSettings.hasFunctionValue("filesDownloadingSource") ||
                downloadingAndSavingFilesSettings.hasVariableValue("filesDownloadingSource")) {
                toggleFieldsWhenFilesDownloadingSourceIsFunctionOrVariable(downloadingAndSavingFilesSettings);
            } else {
                toggleFieldsWhenFilesDownloadingSourceIsUndefined(downloadingAndSavingFilesSettings);
            }
        }
    }, downloadingAndSavingFilesSettings, null);

    downloadingAndSavingFilesSettings.addField("fileIds");

    let processAndFileIdsDocumentClassesMapping = downloadingAndSavingFilesSettings.addTable({
        id: "processAndFileIdsDocumentClassesMappingTableId",
        name: ESignature.t("esignature.sign-documents-action.process-and-file-ids-document-classes-table.name"),
        description: ESignature.t("esignature.sign-documents-action.process-and-file-ids-document-classes-table.desc")
    });
    ESignature.addComboboxClassList("processAndFileIdsSourceDocumentClasses", null, processAndFileIdsDocumentClassesMapping, null);
    ESignature.addComboboxClassList("processAndFileIdsDestinationDocumentClasses", null, processAndFileIdsDocumentClassesMapping, null);


    buildComboboxClassAndIndexList(downloadingAndSavingFilesSettings, "documentClassArchive", "indexNameFilter",
        "indexValueFilter", "indexTableFilter", "esignature.sign-documents-action.index-table-filter");

    downloadingAndSavingFilesSettings.addField({
        id: "saveAsNewVersion",
        listeners: {
            change: function(value) {
                if (!value) {
                    toggleFieldsWhenSaveAsNewVersionIsFalse(downloadingAndSavingFilesSettings);
                } else if (downloadingAndSavingFilesSettings.hasFunctionValue("saveAsNewVersion") ||
                    downloadingAndSavingFilesSettings.hasVariableValue("saveAsNewVersion")) {
                    toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(downloadingAndSavingFilesSettings);
                } else {
                    toggleFieldsWhenSaveAsNewVersionIsTrue(downloadingAndSavingFilesSettings);
                }
            }
        }
    });

    buildComboboxClassAndIndexList(downloadingAndSavingFilesSettings, "documentClassToSave",
        "indexNameToSave", "indexValueToSave",
        "indexMappingTableFromArchiveOption", "esignature.sign-documents-action.index-table-to-save");

    buildProcessAndFileIdsDocumentClassIndexMappingTable(downloadingAndSavingFilesSettings, "processAndFileIdsDocumentClassesToSave",
        "processAndFileIdsIndexNameToSave", "processAndFileIdsIndexValueToSave", form);

    downloadingAndSavingFilesSettings.addField("addDocumentToProcess");
    addAdditionalDownloadingAndSavingFilesSettings(downloadingAndSavingFilesSettings);

    afterDownloadingAndSavingFilesSettingsLoad(downloadingAndSavingFilesSettings);
}

function buildComboboxClassAndIndexList(form, documentClass, indexName, indexValue, tableId, tableName) {
    ESignature.addComboboxClassList(documentClass, {
        change: function(value) {
            let position = form.getFieldPosition(indexName);
            form.removeField(indexName);
            if (form.hasVariableValue(documentClass) || form.hasFunctionValue(documentClass)) {
                indexTable.addField(indexName, position);
            } else {
                ESignature.addComboboxClassIndexList(indexName, value, indexTable, 0);
            }
            ESignature.clearColumnValues(indexName, form);
        }
    }, form, null);
    let indexTable = form.addTable({
        id: tableId,
        name: ESignature.t(tableName),
    });

    ESignature.addComboboxClassIndexList(indexName, form.getValue(documentClass), indexTable, 0);
    if (form.hasVariableValue(documentClass) || form.hasFunctionValue(documentClass)) {
        indexTable.addField(indexName);
    } else {
        ESignature.addComboboxClassIndexList(indexName, form.getValue(documentClass), indexTable, 0);
    }
    indexTable.addField(indexValue);
}

function buildProcessAndFileIdsDocumentClassIndexMappingTable(fieldSet, documentClasses, indexName, indexValue, parentForm) {
    let documentClassIndexMappingTable = fieldSet.addTable({
        id: "indexMappingTableFromProcessAndFileIdsOption",
        name: ESignature.t("esignature.sign-documents-action.index-table-to-save")
    });

    ESignature.addComboboxClassList(documentClasses, {
            change: function(value, options) {
                ESignature.clearColumnRowValue(parentForm, indexName, options.rowIndex);
                ESignature.clearColumnRowValue(parentForm, indexValue, options.rowIndex);
            }
        },
        documentClassIndexMappingTable, null);

    ESignature.addComboboxClassIndexListBasedOnDocumentClassRow(indexName, documentClasses, documentClassIndexMappingTable, parentForm, null);
    documentClassIndexMappingTable.addField(indexValue);
}

function addAdditionalDownloadingAndSavingFilesSettings(form) {
    let additionalSavingSignatureFilesSettings = form.addFieldSet({
        id: "additional-saving-signature-file-settings-fs",
        collapsible: true,
        collapsed: true,
        title: ESignature.t("esignature.sign-documents-action.additional-settings")
    });
    additionalSavingSignatureFilesSettings.addField("executeArchiveActions");
    additionalSavingSignatureFilesSettings.addField("saveFormAfterActionExecution");
}

function afterDownloadingAndSavingFilesSettingsLoad(form) {
    if (form.getValue("filesDownloadingSource") === "PROCESS") {
        toggleFieldsWhenFilesDownloadingSourceIsProcess(form);
    } else if (form.getValue("filesDownloadingSource") === "ARCHIVE") {
        toggleFieldsWhenFilesDownloadingSourceIsArchive(form);
    } else if (form.getValue("filesDownloadingSource") === "FILEIDS") {
        toggleFieldsWhenFilesDownloadingSourceIsFileIds(form);
    } else if (form.hasFunctionValue("filesDownloadingSource") ||
        form.hasVariableValue("filesDownloadingSource")) {
        toggleFieldsWhenFilesDownloadingSourceIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenFilesDownloadingSourceIsUndefined(form);
    }
}

function toggleFieldsWhenFilesDownloadingSourceIsProcess(form) {
    form.setNotEmpty("processAndFileIdsDocumentClassesMappingTableId", true);
    form.show("processAndFileIdsDocumentClassesMappingTableId");
    form.show("saveAsNewVersion");
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveAsNewVersionIsTrue(form);
    }
    form.show("additional-saving-signature-file-settings-fs");
    form.setNotEmpty("documentClassArchive", false);
    form.hide("documentClassArchive");
    form.hide("indexTableFilter");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
}

function toggleFieldsWhenFilesDownloadingSourceIsArchive(form) {
    form.setNotEmpty("documentClassArchive", true);
    form.show("documentClassArchive");
    form.show("indexTableFilter");
    form.show("saveAsNewVersion");
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveAsNewVersionIsTrue(form);
    }
    form.show("additional-saving-signature-file-settings-fs");
    form.setNotEmpty("processAndFileIdsDocumentClassesMappingTableId", false);
    form.hide("processAndFileIdsDocumentClassesMappingTableId");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
}

function toggleFieldsWhenFilesDownloadingSourceIsFileIds(form) {
    form.setNotEmpty("processAndFileIdsDocumentClassesMappingTableId", true);
    form.show("processAndFileIdsDocumentClassesMappingTableId");
    form.setNotEmpty("fileIds", true);
    form.show("fileIds");
    form.show("saveAsNewVersion");
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveAsNewVersionIsTrue(form);
    }
    form.show("additional-saving-signature-file-settings-fs");
    form.setNotEmpty("documentClassArchive", false);
    form.hide("documentClassArchive");
    form.hide("indexTableFilter");
}

function toggleFieldsWhenFilesDownloadingSourceIsFunctionOrVariable(form) {
    form.setNotEmpty("processAndFileIdsDocumentClassesMappingTableId", false);
    form.show("processAndFileIdsDocumentClassesMappingTableId");
    form.setNotEmpty("documentClassArchive", false);
    form.show("documentClassArchive");
    form.show("indexTableFilter");
    form.setNotEmpty("fileIds", false);
    form.show("fileIds");
    form.show("saveAsNewVersion");
    if (!form.getValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFalse(form);
    } else if (form.hasFunctionValue("saveAsNewVersion") || form.hasVariableValue("saveAsNewVersion")) {
        toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveAsNewVersionIsTrue(form);
    }
    form.show("additional-saving-signature-file-settings-fs");
}

function toggleFieldsWhenFilesDownloadingSourceIsUndefined(form) {
    form.hide("saveAsNewVersion");
    form.setNotEmpty("processAndFileIdsDocumentClassesMappingTableId", false);
    form.hide("processAndFileIdsDocumentClassesMappingTableId");
    form.setNotEmpty("documentClassArchive", false);
    form.hide("documentClassArchive");
    form.hide("indexTableFilter");
    form.setNotEmpty("fileIds", false);
    form.hide("fileIds");
    form.hide("indexMappingTableFromProcessAndFileIdsOption");
    form.setNotEmpty("documentClassToSave", false);
    form.hide("documentClassToSave");
    form.hide("indexMappingTableFromArchiveOption");
    form.hide("addDocumentToProcess");
    form.hide("additional-saving-signature-file-settings-fs");
}

function toggleFieldsWhenSaveAsNewVersionIsFalse(form) {
    if (form.getValue("filesDownloadingSource") === "PROCESS") {
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", true);
        form.show("processAndFileIdsDestinationDocumentClasses");
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.hide("documentClassToSave");
        form.hide("indexMappingTableFromArchiveOption");
    } else if (form.getValue("filesDownloadingSource") === "ARCHIVE") {
        form.setNotEmpty("documentClassToSave", true);
        form.show("documentClassToSave");
        form.show("indexMappingTableFromArchiveOption");
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", false);
        form.hide("indexMappingTableFromProcessAndFileIdsOption");
    } else if (form.getValue("filesDownloadingSource") === "FILEIDS") {
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", true);
        form.show("processAndFileIdsDestinationDocumentClasses");
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.hide("documentClassToSave");
        form.hide("indexMappingTableFromArchiveOption");
    } else {
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", false);
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.show("documentClassToSave");
        form.show("indexMappingTableFromArchiveOption");
    }
    form.show("addDocumentToProcess");
}

function toggleFieldsWhenSaveAsNewVersionIsFunctionOrVariable(form) {
    if (form.getValue("filesDownloadingSource") === "PROCESS") {
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", false);
        form.show("processAndFileIdsDestinationDocumentClasses");
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.hide("documentClassToSave");
        form.hide("indexMappingTableFromArchiveOption");
    } else if (form.getValue("filesDownloadingSource") === "ARCHIVE") {
        form.setNotEmpty("documentClassToSave", false);
        form.show("documentClassToSave");
        form.show("indexMappingTableFromArchiveOption");
        form.hide("indexMappingTableFromProcessAndFileIdsOption");
    } else if (form.getValue("filesDownloadingSource") === "FILEIDS") {
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.hide("documentClassToSave");
        form.hide("indexMappingTableFromArchiveOption");
    } else {
        form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", false);
        form.show("indexMappingTableFromProcessAndFileIdsOption");
        form.setNotEmpty("documentClassToSave", false);
        form.show("documentClassToSave");
        form.show("indexMappingTableFromArchiveOption");
    }
    form.show("addDocumentToProcess");
}

function toggleFieldsWhenSaveAsNewVersionIsTrue(form) {
    form.setNotEmpty("processAndFileIdsDestinationDocumentClasses", false);
    form.hide("processAndFileIdsDestinationDocumentClasses");
    setColumnWithEmptyValues(form, "processAndFileIdsDestinationDocumentClasses");
    form.hide("indexMappingTableFromProcessAndFileIdsOption");
    form.setNotEmpty("documentClassToSave", false);
    form.hide("documentClassToSave");
    form.hide("indexMappingTableFromArchiveOption");
    form.hide("addDocumentToProcess");
}

function setColumnWithEmptyValues(form, parameterName) {
    for (let index = 0; index < form.getValue(parameterName).length; index++) {
        form.setFieldValueInArray(parameterName, index, "");
    }
}

function addSignatureSettings(form) {
    let signatureSettings = form.addFieldSet({
        id: "signature-settings-fs",
        collapsible: true,
        collapsed: false,
        title: ESignature.t("esignature.sign-documents-action.signature-settings")
    });
    signatureSettings.addCombobox({
        id: "modeOfOperation",
        values: [
            {id: "SZAFIR_WINDOW", display: ESignature.t("esignature.sign-documents-action.mode-of-operation.szafir-window")},
            {id: "PIN_AND_CERTIFICATE_WINDOW", display: ESignature.t("esignature.sign-documents-action.mode-of-operation.pin-and-certificate-window")}
        ],
        listeners: {
            change: function (value) {
                if (value === "SZAFIR_WINDOW") {
                    toggleFieldsWhenModeOfOperationIsSzafirWindow(signatureSettings);
                } else if (value === "PIN_AND_CERTIFICATE_WINDOW") {
                    toggleFieldsWhenModeOfOperationIsWindowless(signatureSettings);
                } else if (signatureSettings.hasFunctionValue("modeOfOperation") ||
                    signatureSettings.hasVariableValue("modeOfOperation")) {
                    toggleFieldsWhenModeOfOperationIsFunctionOrVariable(signatureSettings);
                } else {
                    toggleFieldsWhenModeOfOperationIsUndefined(signatureSettings);
                }
            }
        }
    });
    ESignature.addComboboxConfigurationList("certificate", signatureSettings, null);

    signatureSettings.addField({
        id: "userSelectsCertificate",
        listeners: {
            change: function(value) {
                if (!value) {
                    signatureSettings.hide("availableCertificates");
                    signatureSettings.setNotEmpty("certificate", true);
                    signatureSettings.show("certificate");
                } else if (signatureSettings.hasFunctionValue("userSelectsCertificate") ||
                    signatureSettings.hasVariableValue("userSelectsCertificate")) {
                    signatureSettings.show("availableCertificates");
                    signatureSettings.setNotEmpty("certificate", false);
                    signatureSettings.show("certificate");
                } else {
                    signatureSettings.show("availableCertificates");
                    signatureSettings.setNotEmpty("certificate", false);
                    signatureSettings.hide("certificate");
                }
            }
        }
    });
    ESignature.addComboboxConfigurationList("availableCertificates", signatureSettings, null );
    buildComboboxSignatureVersionsAndFormats(signatureSettings);
    addGraphicElementSettings(signatureSettings);
    addAdditionalSignatureSettings(signatureSettings);
    afterSignatureSettingsLoad(signatureSettings);
}

function addGraphicElementSettings(form) {
    let graphicElementSettings = form.addFieldSet({
        id: "graphic-element-settings-fs",
        collapsible: true,
        collapsed: false,
        title: ESignature.t("esignature.sign-documents-action.graphic-element-settings")
    });
    graphicElementSettings.addField({
        id: "automaticInsertionOfGraphicElement",
        listeners: {
            change: function (value) {
                if (!value) {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsFalse(graphicElementSettings);
                } else if (graphicElementSettings.hasVariableValue("automaticInsertionOfGraphicElement") ||
                    graphicElementSettings.hasFunctionValue("automaticInsertionOfGraphicElement")) {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsVariableOrFunction(graphicElementSettings);
                } else {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsTrue(graphicElementSettings);
                }
            }
        }
    });
    graphicElementSettings.addField({
        id: "insertImageFile",
        listeners: {
            change: function (value) {
                if (!value) {
                    toggleFieldWhenInsertImageFileIsFalse(graphicElementSettings);
                } else if (graphicElementSettings.hasVariableValue("insertImageFile") || graphicElementSettings.hasFunctionValue("insertImageFile")) {
                    toggleFieldWhenInsertImageFileIsVariableOrFunction(graphicElementSettings);
                } else {
                    toggleFieldWhenInsertImageFileIsTrue(graphicElementSettings);
                }
            }
        }
    });
    graphicElementSettings.addField("pathToImageFile");
    graphicElementSettings.addField("documentPageNumber");
    graphicElementSettings.addField("distanceFromTheLeftEdge");
    graphicElementSettings.addField("distanceFromTheBottomEdge");
    graphicElementSettings.addField("graphicElementHeight");
    graphicElementSettings.addField("graphicElementWidth");
}

function toggleFieldsWhenAutomaticInsertionOfGraphicElementIsFalse(form) {
    form.setNotEmpty("insertImageFile", false);
    form.hide("insertImageFile");
    toggleFieldWhenInsertImageFileIsFalse(form);
    form.setNotEmpty("documentPageNumber", false);
    form.hide("documentPageNumber");
    form.setNotEmpty("distanceFromTheLeftEdge", false);
    form.hide("distanceFromTheLeftEdge");
    form.setNotEmpty("distanceFromTheBottomEdge", false);
    form.hide("distanceFromTheBottomEdge");
    form.setNotEmpty("graphicElementHeight", false);
    form.hide("graphicElementHeight");
    form.setNotEmpty("graphicElementWidth", false);
    form.hide("graphicElementWidth");
}

function toggleFieldsWhenAutomaticInsertionOfGraphicElementIsVariableOrFunction(form) {
    form.setNotEmpty("insertImageFile", false);
    form.show("insertImageFile");
    if (!form.getValue("insertImageFile")) {
        toggleFieldWhenInsertImageFileIsFalse(form);
    } else if (form.hasVariableValue("insertImageFile") || form.hasFunctionValue("insertImageFile")) {
        toggleFieldWhenInsertImageFileIsVariableOrFunction(form);
    } else {
        toggleFieldWhenInsertImageFileIsTrue(form);
    }
    form.setNotEmpty("documentPageNumber", false);
    form.show("documentPageNumber");
    form.setNotEmpty("distanceFromTheLeftEdge", false);
    form.show("distanceFromTheLeftEdge");
    form.setNotEmpty("distanceFromTheBottomEdge", false);
    form.show("distanceFromTheBottomEdge");
    form.setNotEmpty("graphicElementHeight", false);
    form.show("graphicElementHeight");
    form.setNotEmpty("graphicElementWidth", false);
    form.show("graphicElementWidth");
}

function toggleFieldsWhenAutomaticInsertionOfGraphicElementIsTrue(form) {
    form.setNotEmpty("insertImageFile", true);
    form.show("insertImageFile");
    if (!form.getValue("insertImageFile")) {
        toggleFieldWhenInsertImageFileIsFalse(form);
    } else if (form.hasVariableValue("insertImageFile") || form.hasFunctionValue("insertImageFile")) {
        toggleFieldWhenInsertImageFileIsVariableOrFunction(form);
    } else {
        toggleFieldWhenInsertImageFileIsTrue(form);
    }
    form.setNotEmpty("documentPageNumber", true);
    form.show("documentPageNumber");
    form.setNotEmpty("distanceFromTheLeftEdge", true);
    form.show("distanceFromTheLeftEdge");
    form.setNotEmpty("distanceFromTheBottomEdge", true);
    form.show("distanceFromTheBottomEdge");
    form.setNotEmpty("graphicElementHeight", true);
    form.show("graphicElementHeight");
    form.setNotEmpty("graphicElementWidth", true);
    form.show("graphicElementWidth");
}

function toggleFieldWhenInsertImageFileIsFalse(form) {
    form.setNotEmpty("pathToImageFile", false)
    form.hide("pathToImageFile");
}

function toggleFieldWhenInsertImageFileIsVariableOrFunction(form) {
    form.setNotEmpty("pathToImageFile", false)
    form.show("pathToImageFile");
}

function toggleFieldWhenInsertImageFileIsTrue(form) {
    form.setNotEmpty("pathToImageFile", true)
    form.show("pathToImageFile");
}

function addAdditionalSignatureSettings(form) {
    let additionalSignatureSettings = form.addFieldSet({
        id: "additional-signature-settings-fs",
        collapsible: true,
        collapsed: true,
        title: ESignature.t("esignature.sign-documents-action.additional-settings")
    });
    additionalSignatureSettings.addField("debugMode");
    addInformationAboutSigningFilesResult(additionalSignatureSettings);
}

function addInformationAboutSigningFilesResult(form) {
    let informationAboutSigningFilesResultSettings = form.addFieldSet({
        id: "information-about-signing-files-result-fs",
        collapsible: true,
        collapsed: false,
        title: ESignature.t("esignature.sign-documents-action.information-about-signing-files-result-settings")
    });

    informationAboutSigningFilesResultSettings.addField({
        id: "saveSigningFilesInformation",
        listeners: {
            change: function(value) {
                if (!value) {
                    toggleFieldsWhenSaveSigningFilesInformationIsFalse(informationAboutSigningFilesResultSettings);
                } else if (informationAboutSigningFilesResultSettings.hasFunctionValue("saveSigningFilesInformation") ||
                    informationAboutSigningFilesResultSettings.hasVariableValue("saveSigningFilesInformation")) {
                    toggleFieldsWhenSaveSigningFilesInformationIsFunctionOrVariable(informationAboutSigningFilesResultSettings);
                } else {
                    toggleFieldsWhenSaveSigningFilesInformationIsTrue(informationAboutSigningFilesResultSettings);
                }
            }
        }
    });

    ESignature.addSavingSigningInformationModeList("savingSigningInformationMode", informationAboutSigningFilesResultSettings, null);

    informationAboutSigningFilesResultSettings.addField("sourceFileIds");
    informationAboutSigningFilesResultSettings.addField("sourceFileNames");
    informationAboutSigningFilesResultSettings.addField("fileIdsOfSignedFiles");
    informationAboutSigningFilesResultSettings.addField("signatureRealizationStatuses");
    informationAboutSigningFilesResultSettings.addField("errorDescriptions");

    setTimeout(function(){
        afterInformationAboutSigningFilesResultLoad(informationAboutSigningFilesResultSettings);
    }, 0);
}

function buildComboboxSignatureVersionsAndFormats(form) {
    ESignature.addComboboxSignatureVersionList("signatureVersion", {
        change: function(value) {
            form.removeField("signatureFormat");
            if (form.getValue("signatureVersion") || form.hasVariableValue("signatureVersion") || form.hasFunctionValue("signatureVersion")) {
                buildComboboxSignatureFormatList("signatureFormat", form, form.getFieldPosition("graphic-element-settings-fs"), false);
            } else {
                form.setNotEmpty("signatureFormat", false);
                form.hide("signatureFormat");
            }
            form.setValue("signatureFormat", "");
        }
    }, form, null);

    buildComboboxSignatureFormatList("signatureFormat", form, null, false);
}

function buildComboboxSignatureFormatList(idName, form, position, optionalParam) {
    if (form.hasVariableValue("signatureVersion") || form.hasFunctionValue("signatureVersion")) {
        ESignature.addComboboxAllSignatureFormatList(idName, buildFormatListComboboxChangeListener(form), form, position, optionalParam)
    } else {
        ESignature.addComboboxSignatureFormatList(idName, buildFormatListComboboxChangeListener(form), form.getValue("signatureVersion"), form, position, optionalParam)
    }
}

function buildFormatListComboboxChangeListener(form) {
    return {
        change: function (value) {
            if (form.hasVariableValue("signatureFormat") || form.hasFunctionValue("signatureFormat")
                || value === "PADES_BES" || value === "PADES_T" || value === "PADES_LTV" || value === "PADES_LTV_REFRESH") {
                form.show("graphic-element-settings-fs");
                form.setNotEmpty("automaticInsertionOfGraphicElement", true);
                if (!form.getValue("automaticInsertionOfGraphicElement")) {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsFalse(form);
                } else if (form.hasVariableValue("automaticInsertionOfGraphicElement") ||
                    form.hasFunctionValue("automaticInsertionOfGraphicElement")) {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsVariableOrFunction(form);
                } else {
                    toggleFieldsWhenAutomaticInsertionOfGraphicElementIsTrue(form);
                }
            } else {
                form.hide("graphic-element-settings-fs");
                form.setNotEmpty("automaticInsertionOfGraphicElement", false);
            }
        }
    }
}

function afterInformationAboutSigningFilesResultLoad(form) {
    if (!form.getValue("saveSigningFilesInformation")) {
        toggleFieldsWhenSaveSigningFilesInformationIsFalse(form);
    } else if (form.hasFunctionValue("saveSigningFilesInformation") || form.hasVariableValue("saveSigningFilesInformation")) {
        toggleFieldsWhenSaveSigningFilesInformationIsFunctionOrVariable(form);
    } else {
        toggleFieldsWhenSaveSigningFilesInformationIsTrue(form);
    }
}

function toggleFieldsWhenSaveSigningFilesInformationIsFalse(form) {
    form.setNotEmpty("savingSigningInformationMode", false);
    form.hide("savingSigningInformationMode");
    form.setNotEmpty("sourceFileIds", false);
    form.hide("sourceFileIds");
    form.hide("sourceFileNames");
    form.hide("fileIdsOfSignedFiles");
    form.hide("signatureRealizationStatuses");
    form.hide("errorDescriptions");
}

function toggleFieldsWhenSaveSigningFilesInformationIsFunctionOrVariable(form) {
    form.setNotEmpty("savingSigningInformationMode", false);
    form.show("savingSigningInformationMode");
    form.setNotEmpty("sourceFileIds", false);
    form.show("sourceFileIds");
    form.show("sourceFileNames");
    form.show("fileIdsOfSignedFiles");
    form.show("signatureRealizationStatuses");
    form.show("errorDescriptions");
}

function toggleFieldsWhenSaveSigningFilesInformationIsTrue(form) {
    form.setNotEmpty("savingSigningInformationMode", true);
    form.show("savingSigningInformationMode");
    form.setNotEmpty("sourceFileIds", true);
    form.show("sourceFileIds");
    form.show("sourceFileNames");
    form.show("fileIdsOfSignedFiles");
    form.show("signatureRealizationStatuses");
    form.show("errorDescriptions");
}

function afterSignatureSettingsLoad(form) {
    if (form.getValue("modeOfOperation") === "SZAFIR_WINDOW") {
        toggleFieldsWhenModeOfOperationIsSzafirWindow(form);
        form.setNotEmpty("signatureFormat", true);
        form.show("signatureFormat");
    } else if (form.getValue("modeOfOperation") === "PIN_AND_CERTIFICATE_WINDOW") {
        toggleFieldsWhenModeOfOperationIsWindowless(form);
        form.setNotEmpty("signatureFormat", true);
        form.show("signatureFormat");
    } else if (form.hasFunctionValue("modeOfOperation") ||
        form.hasVariableValue("modeOfOperation")) {
        toggleFieldsWhenModeOfOperationIsFunctionOrVariable(form);
        form.setNotEmpty("signatureFormat", true);
        form.show("signatureFormat");
    } else {
        toggleFieldsWhenModeOfOperationIsUndefined(form);
        form.setNotEmpty("signatureFormat", false);
        form.hide("signatureFormat");
    }

    if (form.getValue("signatureFormat") === "PADES_BES" || form.getValue("signatureFormat") === "PADES_T" ||
        form.getValue("signatureFormat") === "PADES_LTV" || form.getValue("signatureFormat") === "PADES_LTV_REFRESH" ||
        form.hasFunctionValue("signatureFormat") || form.hasVariableValue("signatureFormat")) {
        form.show("graphic-element-settings-fs");
        form.setNotEmpty("automaticInsertionOfGraphicElement", true);
        if (!form.getValue("automaticInsertionOfGraphicElement")) {
            toggleFieldsWhenAutomaticInsertionOfGraphicElementIsFalse(form);
        } else if (form.hasVariableValue("automaticInsertionOfGraphicElement") || form.hasFunctionValue("automaticInsertionOfGraphicElement")) {
            toggleFieldsWhenAutomaticInsertionOfGraphicElementIsVariableOrFunction(form);
        } else {
            toggleFieldsWhenAutomaticInsertionOfGraphicElementIsTrue(form);
        }
    } else {
        form.hide("graphic-element-settings-fs");
        form.setNotEmpty("automaticInsertionOfGraphicElement", false);
    }
}

function toggleFieldsWhenModeOfOperationIsSzafirWindow(form) {
    form.setNotEmpty("certificate", true);
    form.show("certificate");
    form.setNotEmpty("userSelectsCertificate", false);
    form.hide("userSelectsCertificate");
    form.hide("availableCertificates");
}

function toggleFieldsWhenModeOfOperationIsWindowless(form) {
    form.setNotEmpty("userSelectsCertificate", true);
    form.show("userSelectsCertificate");
    if (form.hasFunctionValue("userSelectsCertificate") ||
        form.hasVariableValue("userSelectsCertificate")) {
        form.show("availableCertificates");
        form.setNotEmpty("certificate", false);
        form.show("certificate");
    } else if (form.getValue("userSelectsCertificate")) {
        form.show("availableCertificates");
        form.setNotEmpty("certificate", false);
        form.hide("certificate");
    } else {
        form.setNotEmpty("certificate", true);
        form.show("certificate");
        form.hide("availableCertificates");
    }
}

function toggleFieldsWhenModeOfOperationIsFunctionOrVariable(form) {
    form.setNotEmpty("certificate", false);
    form.show("certificate");
    form.setNotEmpty("userSelectsCertificate", false);
    form.show("userSelectsCertificate");
    if (form.getValue("userSelectsCertificate") ||
        form.hasFunctionValue("userSelectsCertificate") ||
        form.hasVariableValue("userSelectsCertificate")) {
        form.show("availableCertificates");
    } else {
        form.hide("availableCertificates");
    }
}

function toggleFieldsWhenModeOfOperationIsUndefined(form) {
    form.setNotEmpty("certificate", false);
    form.hide("certificate");
    form.setNotEmpty("userSelectsCertificate", false);
    form.hide("userSelectsCertificate");
    form.hide("availableCertificates");
}

function validateProcessAndFileIdsSourceDocumentClasses(api) {
    for (let index = 0; index < api.getArraySize("processAndFileIdsSourceDocumentClasses"); index++) {
        if (api.hasVariableValue("processAndFileIdsSourceDocumentClasses", index) ||
            api.hasFunctionValue("processAndFileIdsSourceDocumentClasses", index)) {
            return true;
        }
    }
    if (api.getArraySize("processAndFileIdsSourceDocumentClasses") !== new Set(api.getValue("processAndFileIdsSourceDocumentClasses")).size) {
        api.markError("processAndFileIdsSourceDocumentClasses");
        api.showErrorMessage(ESignature.t("esignature.sign-documents-action.source-process-document-classes.duplicates-error"));
        return false;
    }
    return true;
}

function validateProcessAndFileIdsDocumentClassIndexMappingTable(api) {
    if (!api.getValue("saveAsNewVersion")) {
        for (let index = 0; index < api.getArraySize("processAndFileIdsDestinationDocumentClasses"); index++) {
            if (api.hasVariableValue("processAndFileIdsDestinationDocumentClasses", index) ||
                api.hasFunctionValue("processAndFileIdsDestinationDocumentClasses", index)) {
                return true;
            }
        }
        for (let index = 0; index < api.getArraySize("processAndFileIdsDocumentClassesToSave"); index++) {
            if (api.hasVariableValue("processAndFileIdsDocumentClassesToSave", index) || api.hasFunctionValue("processAndFileIdsDocumentClassesToSave", index)) {
                continue;
            }
            if (!api.getValue("processAndFileIdsDestinationDocumentClasses").includes(api.getValue("processAndFileIdsDocumentClassesToSave")[index])) {
                api.markError("processAndFileIdsDocumentClassesToSave", index);
                api.showErrorMessage(ESignature.t("esignature.sign-documents-action.process-document-classes-to-save.not-mapped-document-class-error"));
                return false;
            }
        }
    }
    return true;
}

function validateGraphicElementCoordinates(api) {
    let distanceFromTheLeftEdge = api.getValue("distanceFromTheLeftEdge");
    if (distanceFromTheLeftEdge < 0 || distanceFromTheLeftEdge > 100) {
        api.markError("distanceFromTheLeftEdge");
        api.showErrorMessage(ESignature.t("esignature.sign-documents-action.graphic-element-coordinates.error-position-percent"));
        return false;
    }
    let distanceFromTheBottomEdge = api.getValue("distanceFromTheBottomEdge");
    if (distanceFromTheBottomEdge < 0 || distanceFromTheBottomEdge > 100) {
        api.markError("distanceFromTheBottomEdge");
        api.showErrorMessage(ESignature.t("esignature.sign-documents-action.graphic-element-coordinates.error-position-percent"));
        return false;
    }
    let graphicElementHeight = api.getValue("graphicElementHeight");
    if (graphicElementHeight < 0 || graphicElementHeight > 100) {
        api.markError("graphicElementHeight");
        api.showErrorMessage(ESignature.t("esignature.sign-documents-action.graphic-element-coordinates.error-position-percent"));
        return false;
    }
    let graphicElementWidth = api.getValue("graphicElementWidth");
    if (graphicElementWidth < 0 || graphicElementWidth > 100) {
        api.markError("graphicElementWidth");
        api.showErrorMessage(ESignature.t("esignature.sign-documents-action.graphic-element-coordinates.error-position-percent"));
        return false;
    }
}