/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.xml;

import com.suncode.plugin.esignature.xml.exception.EmptyElementNodeException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class XmlManager {
    public Document loadXmlDocumentFromInputStream(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(stream);
    }

    public String getStringFromDocument(Document document) {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public void modifyToArray(Document document, String tagName, List<Map<String, String>> replacementMapList, Boolean automaticInsertionOfGraphicElement, Boolean insertImageFile) {
        Node parentNode = document.getElementsByTagName(tagName).item(0);
        Node elementNode = this.getFirstElementNode(parentNode.getChildNodes()).orElseThrow(() -> new EmptyElementNodeException(tagName));
        this.removeRedundantNodesElement(elementNode, automaticInsertionOfGraphicElement, insertImageFile);
        parentNode.setTextContent("");
        parentNode.appendChild(document.createTextNode("\n"));
        replacementMapList.forEach(replacementMap -> {
            parentNode.appendChild(this.buildNewNodeWithValue(elementNode.cloneNode(true), (Map<String, String>)replacementMap));
            parentNode.appendChild(document.createTextNode("\n"));
        });
    }

    private void removeRedundantNodesElement(Node node, Boolean automaticInsertionOfGraphicElement, Boolean insertImageFile) {
        Node signingTaskItemNode = ((Element)node).getElementsByTagName("SigningTaskItem").item(0);
        Node padesStampNode = ((Element)signingTaskItemNode).getElementsByTagName("PadesStamp").item(0);
        if (!automaticInsertionOfGraphicElement.booleanValue()) {
            signingTaskItemNode.removeChild(padesStampNode);
        } else if (!insertImageFile.booleanValue()) {
            Node imageNode = ((Element)padesStampNode).getElementsByTagName("Image").item(0);
            padesStampNode.removeChild(imageNode);
        }
    }

    private Optional<Node> getFirstElementNode(NodeList childNodes) {
        for (int indexNode = 0; indexNode < childNodes.getLength(); ++indexNode) {
            Node childNode = childNodes.item(indexNode);
            if (childNode.getNodeType() != 1) continue;
            return Optional.of(childNode);
        }
        return Optional.empty();
    }

    private Node buildNewNodeWithValue(Node node, Map<String, String> replacementMap) {
        NodeList childNodes = node.getChildNodes();
        block4: for (int indexNode = 0; indexNode < childNodes.getLength(); ++indexNode) {
            Node childNode = childNodes.item(indexNode);
            switch (childNode.getNodeType()) {
                case 1: {
                    this.buildNewNodeWithValue(childNode, replacementMap);
                }
                case 3: {
                    String value = childNode.getNodeValue();
                    if (!StringUtils.isNotBlank((CharSequence)value) || !replacementMap.containsKey(value)) continue block4;
                    childNode.setNodeValue(replacementMap.get(value));
                    continue block4;
                }
            }
        }
        return node;
    }
}

