/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.upgrade;

import com.suncode.plugin.esignature.util.PlusESignSpringContext;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.model.FileType;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.io.IOUtils;

public class CreatePlusESignatureConfigCustomChange
implements CustomTaskChange {
    private static final String SETTINGS_CRYPTOPROVIDERS_FILE_ID = "settings_cryptoproviders";

    public void execute(Database database) {
        Plugin plugin;
        ConfigurationFileService configurationFileService = PlusESignSpringContext.getBean(ConfigurationFileService.class);
        if (!configurationFileService.doesFileExist((plugin = PlusESignSpringContext.getBean(Plugin.class)).getKey(), SETTINGS_CRYPTOPROVIDERS_FILE_ID)) {
            configurationFileService.createFile(plugin.getKey(), SETTINGS_CRYPTOPROVIDERS_FILE_ID, FileType.XML);
            String template = this.getSettingsCryptoprovidersTemplate();
            configurationFileService.saveFile(plugin.getKey(), SETTINGS_CRYPTOPROVIDERS_FILE_ID, (InputStream)new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSettingsCryptoprovidersTemplate() {
        try (InputStream stream = this.getClass().getResourceAsStream("/template/settings_cryptoproviders.xml");){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

