/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.signature.enums;

import com.suncode.plugin.esignature.combobox.dto.ComboBoxElementDto;
import com.suncode.plugin.esignature.combobox.dto.ElementParam;

public enum SignatureFormat implements ElementParam
{
    XADES_BES("XAdES-BES", "BES", ".XAdES"),
    EPO_XADES_BES("EPO-XAdES-BES", "BES", ".XAdES"),
    CADES_BES("CAdES-BES", "BES", ".sig"),
    PKCS7("PKCS#7", "BES", ".sig"),
    PADES_BES("PAdES-BES", "BES", ".pdf"),
    ASIC_S_XADES_BES("ASIC-S-XAdES-BES", "BES", ".asics"),
    ASIC_S_CADES_BES("ASIC-S-CAdES-BES", "BES", ".asics"),
    XADES_T("XAdES-T", "T", ".XAdES"),
    EPO_XADES_T("EPO-XAdES-T", "T", ".XAdES"),
    CADES_T("CAdES-T", "T", ".sig"),
    PKCS7_T("PKCS#7-T", "T", ".sig"),
    PKCS7_WITH_TIME("PKCS#7 with Time", "T", ".sig"),
    PADES_T("PAdES-T", "T", ".pdf"),
    ASIC_S_XADES_T("ASIC-S-XAdES-T", "T", ".asics"),
    ASIC_S_CADES_T("ASIC-S-CAdES-T", "T", ".asics"),
    XADES_A("XAdES-A", "LTV/A", ".XAdES"),
    EPO_XADES_A("EPO-XAdES-A", "LTV/A", ".XAdES"),
    PADES_LTV("PAdES-LTV", "LTV/A", ".pdf"),
    PADES_LTV_REFRESH("PAdES-LTV-REFRESH", "LTV/A", ".pdf"),
    XADES_A_REFRESH("XAdES-A-REFRESH", "LTV/A", ".XAdES"),
    EPO_XADES_A_REFRESH("EPO-XAdES-A-REFRESH", "LTV/A", ".XAdES");

    private final String format;
    private final String version;
    private final String extension;

    private SignatureFormat(String format, String version, String extension) {
        this.format = format;
        this.version = version;
        this.extension = extension;
    }

    public String getFormat() {
        return this.format;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public ComboBoxElementDto build() {
        return ComboBoxElementDto.builder().name(this.getFormat()).value(this.name()).build();
    }
}

