/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.signature.controller;

import com.suncode.plugin.esignature.combobox.dto.ComboBoxElementDto;
import com.suncode.plugin.esignature.combobox.dto.ElementParam;
import com.suncode.plugin.esignature.combobox.service.ComboBoxElementService;
import com.suncode.plugin.esignature.signature.enums.SignatureFormat;
import com.suncode.plugin.esignature.signature.enums.SignatureVersion;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/signature"})
public class SignatureController {
    private final ComboBoxElementService comboBoxElementService;

    @Autowired
    public SignatureController(ComboBoxElementService comboBoxElementService) {
        this.comboBoxElementService = comboBoxElementService;
    }

    @RequestMapping(value={"versions"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getSignatureVersionList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.comboBoxElementService.getElementList(query, start, limit, SignatureVersion.values());
    }

    @RequestMapping(value={"allFormats"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getSignatureAllFormatList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.comboBoxElementService.getElementList(query, start, limit, SignatureFormat.values());
    }

    @RequestMapping(value={"formats/{version}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getSignatureFormatList(@PathVariable(value="version") String signatureVersion, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        ElementParam[] formatsByVersion = this.getFormatsByVersion(SignatureVersion.valueOf(signatureVersion));
        return this.comboBoxElementService.getElementList(query, start, limit, formatsByVersion);
    }

    private SignatureFormat[] getFormatsByVersion(SignatureVersion signatureVersion) {
        return (SignatureFormat[])Arrays.stream(SignatureFormat.values()).filter(format -> format.getVersion().equals(signatureVersion.getVersion())).toArray(SignatureFormat[]::new);
    }
}

