/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.document.service;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.dbspecific.NativeSql;
import com.suncode.plugin.esignature.configuration.dto.FilesWithDestinationDocumentClass;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.search.IndexFilter;
import com.suncode.pwfl.archive.search.SimpleIndexFilter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReadingFileService {
    private static final Logger log = LoggerFactory.getLogger(ReadingFileService.class);
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;

    public List<FilesWithDestinationDocumentClass> readFilesFromProcess(String processId, Map<String, String> documentClassesMapping) {
        ArrayList<FilesWithDestinationDocumentClass> wfFilesWithDocumentClasses = new ArrayList<FilesWithDestinationDocumentClass>();
        documentClassesMapping.entrySet().stream().forEach(documentClassMapping -> {
            List documents = this.documentFinder.getDocumentsFromProcessAndClass(processId, (String)documentClassMapping.getKey(), new String[]{"documentClass"});
            List<WfFile> wfFiles = documents.stream().map(WfDocument::getFile).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(wfFiles)) {
                FilesWithDestinationDocumentClass fileDocumentClassPair = this.createFilesWithDestinationDocumentClass(wfFiles, (String)documentClassMapping.getValue());
                wfFilesWithDocumentClasses.add(fileDocumentClassPair);
            }
        });
        int numberOfAttachedFilesToProcess = this.countNumberOfFoundFiles(wfFilesWithDocumentClasses);
        log.debug("Found " + numberOfAttachedFilesToProcess + " files attached to the process '" + processId + "'");
        return wfFilesWithDocumentClasses;
    }

    public List<FilesWithDestinationDocumentClass> readFilesFromArchive(String documentClassToRead, Map<String, String> indexesMapping, String documentClassToSave) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassToRead, new String[]{"indexes"});
        if (!this.indexesNamesExist(indexesMapping, documentClass)) {
            throw new IllegalArgumentException("An entered index/indexes do not exist in the document class '" + documentClass.getName() + "'");
        }
        List<IndexFilter> indexFilters = this.createIndexFilterList(documentClass, indexesMapping);
        List documents = this.documentFinder.findByIndexes(documentClass.getId(), indexFilters, null, Integer.valueOf(0), Integer.valueOf(0), new String[0]).getData();
        log.debug("Found " + documents.size() + " files in the archive in document Class: " + documentClassToRead);
        List<WfFile> wfFiles = documents.stream().map(WfDocument::getFile).collect(Collectors.toList());
        FilesWithDestinationDocumentClass fileDocumentClassPair = this.createFilesWithDestinationDocumentClass(wfFiles, documentClassToSave);
        return Arrays.asList(fileDocumentClassPair);
    }

    public List<FilesWithDestinationDocumentClass> readSelectedFilesByIds(Long[] fileIdList, Map<String, String> documentClassesMapping) {
        List wfFiles = Arrays.stream(fileIdList).map(fileId -> {
            WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass"});
            if (file == null) {
                throw new RuntimeException("A file with id '" + fileId + "' does not exist in the archive");
            }
            return file;
        }).collect(Collectors.toList());
        ArrayList<FilesWithDestinationDocumentClass> wfFilesWithDocumentClasses = new ArrayList<FilesWithDestinationDocumentClass>();
        documentClassesMapping.entrySet().stream().forEach(documentClassMapping -> {
            List<WfFile> filteredWfFiles = wfFiles.stream().filter(wfFile -> wfFile.getDocumentClass().getName().equals(documentClassMapping.getKey())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filteredWfFiles)) {
                FilesWithDestinationDocumentClass fileDocumentClassPair = this.createFilesWithDestinationDocumentClass(filteredWfFiles, (String)documentClassMapping.getValue());
                wfFilesWithDocumentClasses.add(fileDocumentClassPair);
            }
        });
        return wfFilesWithDocumentClasses;
    }

    private List<IndexFilter> createIndexFilterList(DocumentClass documentClass, Map<String, String> indexesMapping) {
        return documentClass.getIndexes().stream().filter(index -> indexesMapping.containsKey(index.getName()) && StringUtils.isNotBlank((CharSequence)((CharSequence)indexesMapping.get(index.getName())))).map(index -> this.buildIndexFilter((String)indexesMapping.get(index.getName()), (DocumentClassIndex)index)).collect(Collectors.toList());
    }

    private boolean indexesNamesExist(Map<String, String> indexesMapping, DocumentClass documentClass) {
        if (indexesMapping.isEmpty()) {
            return true;
        }
        Set documentClassIndexes = documentClass.getIndexes().stream().map(DocumentClassIndex::getName).collect(Collectors.toSet());
        return CollectionUtils.containsAny(indexesMapping.keySet(), documentClassIndexes);
    }

    private SimpleIndexFilter buildIndexFilter(String stringValue, DocumentClassIndex documentClassIndex) {
        Object value = this.indexConverter(stringValue, documentClassIndex.getType());
        return new SimpleIndexFilter(documentClassIndex.getId(), value);
    }

    private Object indexConverter(String stringValue, IndexType indexType) {
        switch (indexType) {
            case DATE: {
                return this.convertLocaldateToDate(new LocalDate((Object)stringValue));
            }
            case DATETIME: {
                LocalDateTime localDateTime = LocalDateTime.parse((String)stringValue, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                return this.convertLocaldatetimeToTimestamp(localDateTime);
            }
            case DOUBLE: {
                stringValue = stringValue.replaceAll(",", ".");
                return indexType.parse(stringValue);
            }
            case BOOLEAN: {
                boolean booleanValue = StringUtils.isNotBlank((CharSequence)stringValue) && (stringValue.equalsIgnoreCase("true") || stringValue.equals("1"));
                NativeSql databaseImpl = NativeDatabase.getImplementation();
                return databaseImpl.getBooleanValue(booleanValue);
            }
        }
        return indexType.parse(stringValue);
    }

    private Date convertLocaldateToDate(LocalDate date) {
        return date == null ? null : new Date(date.toDateTimeAtStartOfDay(DateTimeZone.forID((String)"UTC")).getMillis());
    }

    private Timestamp convertLocaldatetimeToTimestamp(LocalDateTime dateTime) {
        return dateTime == null ? null : new Timestamp(dateTime.toDateTime().getMillis());
    }

    private FilesWithDestinationDocumentClass createFilesWithDestinationDocumentClass(List<WfFile> wfFiles, String documentClassToSave) {
        FilesWithDestinationDocumentClass fileDocumentClassPair = new FilesWithDestinationDocumentClass();
        fileDocumentClassPair.setWfFiles(wfFiles);
        if (StringUtils.isNotBlank((CharSequence)documentClassToSave)) {
            fileDocumentClassPair.setDocumentClass(documentClassToSave);
        }
        return fileDocumentClassPair;
    }

    private int countNumberOfFoundFiles(List<FilesWithDestinationDocumentClass> filesWithDocumentClasses) {
        return filesWithDocumentClasses.stream().map(wfFilesWithDocumentClass -> wfFilesWithDocumentClass.getWfFiles().size()).reduce(0, Integer::sum);
    }
}

