/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.document.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.esignature.configuration.dto.ActionConfiguration;
import com.suncode.plugin.esignature.configuration.dto.FilesWithDestinationDocumentClass;
import com.suncode.plugin.esignature.configuration.dto.SignatureFileInformation;
import com.suncode.plugin.esignature.configuration.dto.SourceAndDestinationFileIdPair;
import com.suncode.plugin.esignature.document.dto.DocumentClassDto;
import com.suncode.plugin.esignature.document.dto.DocumentClassIndexDto;
import com.suncode.plugin.esignature.document.dto.ProcessAndFileIdsIndexesMapping;
import com.suncode.plugin.esignature.document.enums.FilesDownloadingSource;
import com.suncode.plugin.esignature.signature.enums.SignatureFormat;
import com.suncode.plugin.esignature.util.Base64Util;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.Sorter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ESignatureDocumentService {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final FileService fileService;
    private final DocumentService documentService;
    private final DocumentClassService docClassService;
    private final DocumentClassActionService documentClassActionService;
    private final Map<String, List<SourceAndDestinationFileIdPair>> activitiesWithFileIds = new HashMap<String, List<SourceAndDestinationFileIdPair>>();

    @Autowired
    public ESignatureDocumentService(FileService fileService, DocumentService documentService, DocumentClassService docClassService, DocumentClassActionService documentClassActionService) {
        this.fileService = fileService;
        this.documentService = documentService;
        this.docClassService = docClassService;
        this.documentClassActionService = documentClassActionService;
    }

    public WfDocument addSignatureFileToArchive(String signature, SignatureFileInformation fileInformation) throws Exception {
        WfDocument document;
        DocumentDefinition documentDefinition = this.createDocumentDefinition(signature, fileInformation);
        if (Boolean.TRUE.equals(fileInformation.getSaveAsNewVersion())) {
            Long newestFileVersionId = this.addFileAsNewVersion(documentDefinition, fileInformation.getSourceFileId(), fileInformation.getUserName());
            document = this.documentService.getDocument(newestFileVersionId);
        } else {
            document = this.documentService.addDocument(documentDefinition);
            if (Boolean.TRUE.equals(fileInformation.getAddDocumentToProcess())) {
                this.documentService.attachDocumentToProcess(document, fileInformation.getUserName(), fileInformation.getProcessId(), fileInformation.getActivityId());
            }
        }
        if (Boolean.TRUE.equals(fileInformation.getExecuteArchiveActions())) {
            this.executeDocumentClassActions(document);
        }
        return document;
    }

    private Long addFileAsNewVersion(DocumentDefinition documentDefinition, Long fileId, String userName) throws Exception {
        String currentDocState = this.fileService.getVersionForFile(fileId).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(fileId);
        }
        this.fileService.checkOut(fileId, userName);
        return this.fileService.checkIn(documentDefinition, fileId, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getEncodedFileContent(Long fileId) {
        try (InputStream stream = this.fileService.getFileInputStream(fileId);){
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            String string = Base64Util.encodeBytesToBase64(bytes);
            return string;
        }
    }

    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        DetachedCriteria criteria = DetachedCriteria.forClass(DocumentClass.class);
        if (StringUtils.isNumeric((CharSequence)query)) {
            DocumentClass documentClass2 = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(query)));
            if (documentClass2 != null) {
                DocumentClassDto documentClassDto = DocumentClassDto.builder().id(documentClass2.getId()).name(documentClass2.getName()).build();
                return new CountedResult(1L, Collections.singletonList(documentClassDto));
            }
            return new CountedResult();
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query + "%")));
        }
        CountedResult documentClasses = this.docClassService.getCountedResult(criteria, Pagination.create((Sorter)new Sorter("name"), (Integer)start, (Integer)limit));
        List documentClassesDto = documentClasses.getData().stream().map(documentClass -> new DocumentClassDto(documentClass.getId(), documentClass.getName())).collect(Collectors.toList());
        return new CountedResult(documentClasses.getTotal(), documentClassesDto);
    }

    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexes(String docClassName, String query, Integer start, Integer limit) {
        DocumentClass documentClass = this.docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        try {
            if (documentClass == null) {
                documentClass = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(docClassName)), new String[]{"indexes"});
            }
        }
        catch (Exception e) {
            ArrayList<DocumentClassIndexDto> dataError = new ArrayList<DocumentClassIndexDto>();
            DocumentClassIndexDto documentClassIndex = DocumentClassIndexDto.builder().name("").type("Server error").build();
            dataError.add(documentClassIndex);
            return new CountedResult((long)dataError.size(), dataError);
        }
        Set indexes = documentClass.getIndexes();
        ArrayList<DocumentClassIndexDto> tempDocumentClassIndexes = new ArrayList<DocumentClassIndexDto>();
        for (DocumentClassIndex documentClassIndex : indexes) {
            DocumentClassIndexDto documentClassIndexDto = DocumentClassIndexDto.builder().id(documentClassIndex.getId()).name(documentClassIndex.getName()).type(documentClassIndex.getType().toString()).build();
            tempDocumentClassIndexes.add(documentClassIndexDto);
        }
        List resultList = tempDocumentClassIndexes.stream().filter(index -> index.getName().toLowerCase().contains(query.toLowerCase()) || index.getId().toString().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        resultList = resultList.size() > limit ? resultList.subList(start, start + limit - 1) : resultList;
        return new CountedResult((long)resultList.size(), resultList);
    }

    public List<SignatureFileInformation> buildSignatureFileInformationList(List<FilesWithDestinationDocumentClass> filesWithDocumentClasses, ActionConfiguration config) {
        return filesWithDocumentClasses.stream().map(filesWithDocumentClass -> this.createSingleListOfSignatureFileInformation((FilesWithDestinationDocumentClass)filesWithDocumentClass, config)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<SignatureFileInformation> createSingleListOfSignatureFileInformation(FilesWithDestinationDocumentClass filesWithDocumentClass, ActionConfiguration config) {
        return filesWithDocumentClass.getWfFiles().stream().map(wfFile -> {
            String fileNameWithExtension = this.resolveSignatureFileName(wfFile.getFileName(), config.getSignatureFormat());
            Map<String, String> resolvedIndexesForProcessAndFileIds = this.resolveDocumentIndexes(config, filesWithDocumentClass.getDocumentClass());
            return SignatureFileInformation.builder().sourceFileId(wfFile.getId()).sourceDocumentClassName(wfFile.getDocumentClass().getName()).destinationFileNameWithExtension(fileNameWithExtension).processId(config.getProcessId()).activityId(config.getActivityId()).userName(config.getUserName()).saveAsNewVersion(config.getSaveAsNewVersion()).destinationDocumentClassName(filesWithDocumentClass.getDocumentClass()).indexes(config.getFilesDownloadingSource().equals(FilesDownloadingSource.ARCHIVE.name()) ? config.getIndexesToSave() : resolvedIndexesForProcessAndFileIds).addDocumentToProcess(config.getAddDocumentToProcess()).executeArchiveActions(config.getExecuteArchiveActions()).build();
        }).collect(Collectors.toList());
    }

    public String resolveSignatureFileName(@NonNull String fileName, String format) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        Optional<SignatureFormat> signatureFormat = Optional.of(SignatureFormat.valueOf(format));
        String extension = signatureFormat.get().getExtension();
        return fileName.toUpperCase().endsWith(extension.toUpperCase()) ? fileName : fileName + extension;
    }

    public SignatureFileInformation decodeSignatureFileInformation(String encodedFileInfo) throws IOException {
        SignatureFileInformation fileInformation = (SignatureFileInformation)OBJECT_MAPPER.readValue(Base64Util.decodeBase64ToBytes(encodedFileInfo), SignatureFileInformation.class);
        this.updateSignatureFileIndexesWithKeywords(fileInformation);
        return fileInformation;
    }

    public void addValueToActivitiesWithFileIdsMap(String activityId, Long sourceFileId, Long destinationFileId) {
        SourceAndDestinationFileIdPair fileIdPair = new SourceAndDestinationFileIdPair(sourceFileId, destinationFileId);
        if (!this.activitiesWithFileIds.containsKey(activityId)) {
            this.activitiesWithFileIds.put(activityId, new ArrayList());
        }
        this.activitiesWithFileIds.get(activityId).add(fileIdPair);
    }

    public List<SourceAndDestinationFileIdPair> getSourceAndDestinationFileIdPairs(String activityId) {
        List<SourceAndDestinationFileIdPair> resultList = this.activitiesWithFileIds.get(activityId);
        this.activitiesWithFileIds.remove(activityId);
        return resultList;
    }

    private void updateSignatureFileIndexesWithKeywords(SignatureFileInformation fileInformation) {
        fileInformation.getIndexes().entrySet().forEach(index -> {
            index.setValue(((String)index.getValue()).replace("SOURCE_FILE_ID", fileInformation.getSourceFileId().toString()));
            index.setValue(((String)index.getValue()).replace("SOURCE_DOCUMENT_CLASS_NAME", fileInformation.getSourceDocumentClassName()));
        });
    }

    private Map<String, String> resolveDocumentIndexes(ActionConfiguration config, String documentClass) {
        if (config.getSaveAsNewVersion().booleanValue() || config.getFilesDownloadingSource().equals(FilesDownloadingSource.ARCHIVE.name())) {
            return Collections.emptyMap();
        }
        return config.getProcessAndFileIdsIndexesMappings().stream().filter(indexMapping -> indexMapping.getDocumentClass().equals(documentClass)).collect(Collectors.toMap(ProcessAndFileIdsIndexesMapping::getIndexName, ProcessAndFileIdsIndexesMapping::getIndexValue));
    }

    private DocumentDefinition createDocumentDefinition(String signature, SignatureFileInformation fileConfiguration) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setFileName(fileConfiguration.getDestinationFileNameWithExtension());
        documentDefinition.setUserName(fileConfiguration.getUserName());
        if (!fileConfiguration.getSaveAsNewVersion().booleanValue()) {
            documentDefinition.setDocumentClassId(this.getDocumentClassId(fileConfiguration.getDestinationDocumentClassName()));
            documentDefinition.setIndexes(this.convertIndexes(fileConfiguration.getIndexes(), fileConfiguration.getDestinationDocumentClassName()));
        }
        byte[] fileContent = Base64Util.decodeBase64ToBytes(signature);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(fileContent));
        return documentDefinition;
    }

    private Long getDocumentClassId(String documentClassName) {
        return this.docClassService.getDocumentClass(documentClassName, new String[0]).getId();
    }

    private Map<Long, Object> convertIndexes(Map<String, String> indexesMapping, String docClassName) {
        if (indexesMapping == null) {
            return Collections.emptyMap();
        }
        DocumentClass documentClass = this.docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        return documentClass.getIndexes().stream().filter(docClassIndex -> indexesMapping.containsKey(docClassIndex.getName())).collect(HashMap::new, (map, docClassIndex) -> map.put(docClassIndex.getId(), indexesMapping.get(docClassIndex.getName())), HashMap::putAll);
    }

    private void executeDocumentClassActions(WfDocument document) {
        this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
    }
}

