/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.document.controller;

import com.suncode.plugin.esignature.combobox.dto.ComboBoxElementDto;
import com.suncode.plugin.esignature.combobox.service.ComboBoxElementService;
import com.suncode.plugin.esignature.configuration.dto.SignatureFileInformation;
import com.suncode.plugin.esignature.configuration.dto.SourceAndDestinationFileIdPair;
import com.suncode.plugin.esignature.document.dto.DocumentClassDto;
import com.suncode.plugin.esignature.document.dto.DocumentClassIndexDto;
import com.suncode.plugin.esignature.document.enums.FilesDownloadingSource;
import com.suncode.plugin.esignature.document.enums.SavingSigningInformationMode;
import com.suncode.plugin.esignature.document.service.ESignatureDocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/document"})
public class ESignatureDocumentController {
    private static final Logger log = LoggerFactory.getLogger(ESignatureDocumentController.class);
    private final ESignatureDocumentService eSignatureDocumentService;
    private final ComboBoxElementService comboBoxElementService;

    @Autowired
    public ESignatureDocumentController(ESignatureDocumentService eSignatureDocumentService, ComboBoxElementService comboBoxElementService) {
        this.eSignatureDocumentService = eSignatureDocumentService;
        this.comboBoxElementService = comboBoxElementService;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult saveFileInArchive(@RequestParam(value="signature") String signature, @RequestParam(value="fileInformation") String fileInformation) {
        String errorMessage = "An error occurred while trying to save the signature file to the PlusWorkflow archive.";
        try {
            SignatureFileInformation decodedFileInformation = this.eSignatureDocumentService.decodeSignatureFileInformation(fileInformation);
            WfDocument document = this.eSignatureDocumentService.addSignatureFileToArchive(signature, decodedFileInformation);
            if (document == null) {
                return new RestResult(false, errorMessage + " WfDocument object is null.");
            }
            this.eSignatureDocumentService.addValueToActivitiesWithFileIdsMap(decodedFileInformation.getActivityId(), decodedFileInformation.getSourceFileId(), document.getFile().getId());
            log.debug("A signature file '" + document.getFile().getFileName() + "' was added to the archive with document id " + document.getId() + " and file id " + document.getFile().getId());
            return new RestResult(true);
        }
        catch (IOException e) {
            errorMessage = errorMessage + " Failed to deserialize (convert) a JSON string to SignatureFileInformation java object";
            log.error(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            errorMessage = errorMessage + " Failed to add file as new version.";
            log.error(errorMessage, (Throwable)e);
        }
        return new RestResult(false, errorMessage);
    }

    @RequestMapping(value={"sourceAndDestinationFileIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SourceAndDestinationFileIdPair> getSourceAndDestinationFileIdPairs(@RequestParam String activityId) {
        return this.eSignatureDocumentService.getSourceAndDestinationFileIdPairs(activityId);
    }

    @RequestMapping(value={"filesDownloadingSource"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getFilesDownloadingSourceList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.comboBoxElementService.getElementList(query, start, limit, FilesDownloadingSource.values());
    }

    @RequestMapping(value={"docClasses"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassDto> getDocumentClassList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.eSignatureDocumentService.getDocumentClasses(query, start, limit);
    }

    @RequestMapping(value={"documentClassIndexList/{documentClassName}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexList(@PathVariable(value="documentClassName") String docClassName, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.eSignatureDocumentService.getDocumentClassIndexes(docClassName, query, start, limit);
    }

    @RequestMapping(value={"savingSigningInformationMode"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ComboBoxElementDto> getSavingSigningInformationModeList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.comboBoxElementService.getElementList(query, start, limit, SavingSigningInformationMode.values());
    }
}

