/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.configuration.service;

import com.suncode.plugin.esignature.configuration.dto.ActionConfiguration;
import com.suncode.plugin.esignature.configuration.dto.FilesNumberAndSizeProperties;
import com.suncode.plugin.esignature.configuration.dto.FilesWithDestinationDocumentClass;
import com.suncode.plugin.esignature.configuration.dto.PCMConfigurationFile;
import com.suncode.plugin.esignature.configuration.dto.SignatureFileInformation;
import com.suncode.plugin.esignature.configuration.dto.SummaryFileData;
import com.suncode.plugin.esignature.configuration.dto.TaskListData;
import com.suncode.plugin.esignature.document.enums.FilesDownloadingSource;
import com.suncode.plugin.esignature.document.service.ESignatureDocumentService;
import com.suncode.plugin.esignature.document.service.ReadingFileService;
import com.suncode.plugin.esignature.signature.enums.SignatureFormat;
import com.suncode.plugin.esignature.system.parameters.PluginSystemParameter;
import com.suncode.plugin.esignature.util.Base64Util;
import com.suncode.plugin.esignature.xml.XmlManager;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.CountedResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

@Service
public class ConfigurationService {
    private final Plugin plugin;
    private final ConfigurationFileService configurationFileService;
    private final ESignatureDocumentService eSignatureDocumentService;
    private final ReadingFileService readingFileService;
    private final XmlManager xmlManager;

    @Autowired
    public ConfigurationService(Plugin plugin, ConfigurationFileService configurationFileService, ESignatureDocumentService eSignatureDocumentService, ReadingFileService readingFileService, XmlManager xmlManager) {
        this.plugin = plugin;
        this.configurationFileService = configurationFileService;
        this.eSignatureDocumentService = eSignatureDocumentService;
        this.readingFileService = readingFileService;
        this.xmlManager = xmlManager;
    }

    public CountedResult<PCMConfigurationFile> getConfigurationFiles(String query, Integer start, Integer limit) {
        String[] configurationFiles = this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey());
        List resultList = Arrays.stream(configurationFiles).filter(file -> file.toLowerCase().contains(query.toLowerCase())).map(PCMConfigurationFile::new).collect(Collectors.toList());
        List resultsOnPage = resultList.subList(start, Math.min(resultList.size(), start + limit));
        return new CountedResult((long)resultList.size(), resultsOnPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readSettingsCryptoprovidersConfiguration(String configurationName) {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configurationName);){
            String string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public TaskListData prepareTaskListConfiguration(ActionConfiguration config, String url) {
        List<FilesWithDestinationDocumentClass> filesWithDocumentClasses = this.readFilesFromSystem(config);
        FilesNumberAndSizeProperties filesProperties = this.buildFilesNumberAndSizeProperties(filesWithDocumentClasses);
        List<SignatureFileInformation> fileInformations = this.eSignatureDocumentService.buildSignatureFileInformationList(filesWithDocumentClasses, config);
        List<Map<String, String>> replacementData = this.prepareReplacementData(fileInformations, config, url);
        Document document = this.getXmlDocumentFromTemplate();
        this.xmlManager.modifyToArray(document, "TaskList", replacementData, config.getAutomaticInsertionOfGraphicElement(), config.getInsertImageFile());
        String taskListText = this.xmlManager.getStringFromDocument(document);
        List<String> uuids = this.generateUUIDs(fileInformations.size());
        taskListText = this.updateTaskListWithUUIDs(taskListText, uuids);
        return this.createTaskListData(taskListText, uuids, filesWithDocumentClasses, filesProperties);
    }

    public FilesNumberAndSizeProperties buildFilesNumberAndSizeProperties(List<FilesWithDestinationDocumentClass> filesWithDocumentClasses) {
        int numberOfFiles = 0;
        long sizeOfFiles = 0L;
        for (FilesWithDestinationDocumentClass filesWithDestinationDocumentClass : filesWithDocumentClasses) {
            for (WfFile wfFile : filesWithDestinationDocumentClass.getWfFiles()) {
                ++numberOfFiles;
                sizeOfFiles += wfFile.getSize();
            }
        }
        double calculatedSizeOfFilesInMB = (double)Math.round((double)sizeOfFiles / 1048576.0 * 100.0) / 100.0;
        return FilesNumberAndSizeProperties.builder().numberOfFiles(numberOfFiles).sizeOfFilesMB(calculatedSizeOfFilesInMB).exceedsSpecifiedNumberOfFilesLimit((long)numberOfFiles > SystemProperties.getLong((String)PluginSystemParameter.MAXIMUM_NUMBER_OF_FILES.getKey())).exceedsSpecifiedSizeOfFilesLimitMB(calculatedSizeOfFilesInMB > (double)SystemProperties.getLong((String)PluginSystemParameter.MAXIMUM_SIZE_OF_FILES.getKey()).longValue() || calculatedSizeOfFilesInMB > 40.0).build();
    }

    public List<FilesWithDestinationDocumentClass> readFilesFromSystem(ActionConfiguration config) {
        List<FilesWithDestinationDocumentClass> wfFiles = new ArrayList<FilesWithDestinationDocumentClass>();
        switch (FilesDownloadingSource.valueOf(config.getFilesDownloadingSource())) {
            case PROCESS: {
                wfFiles = this.readingFileService.readFilesFromProcess(config.getProcessId(), config.getProcessAndFileIdsDocumentClassesMapping());
                break;
            }
            case ARCHIVE: {
                wfFiles = this.readingFileService.readFilesFromArchive(config.getDocumentClassArchive(), config.getIndexesFilter(), config.getDocumentClassToSave());
                break;
            }
            case FILEIDS: {
                wfFiles = this.readingFileService.readSelectedFilesByIds(config.getFileIds(), config.getProcessAndFileIdsDocumentClassesMapping());
            }
        }
        return wfFiles;
    }

    private List<Map<String, String>> prepareReplacementData(List<SignatureFileInformation> fileInformations, ActionConfiguration config, String url) throws IOException {
        String endpoint = this.getSaveSignatureEndpoint(url);
        String signatureFormat = SignatureFormat.valueOf(config.getSignatureFormat()).getFormat();
        String encodedGraphicsContent = config.getInsertImageFile() != false ? this.getEncodedGraphicsContent(config.getImageFileConfiguration().getPathToImageFile()) : "";
        return fileInformations.stream().map(fileInfo -> {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            replacementMap.put("$signature_format", signatureFormat);
            String encodedFileContent = this.eSignatureDocumentService.getEncodedFileContent(fileInfo.getSourceFileId());
            replacementMap.put("$encoded_file_content", encodedFileContent);
            String encodedFileInformation = this.encodeFileInformation((SignatureFileInformation)fileInfo);
            replacementMap.put("$url_value", endpoint + encodedFileInformation);
            if (config.getAutomaticInsertionOfGraphicElement().booleanValue()) {
                if (config.getInsertImageFile().booleanValue()) {
                    replacementMap.put("$encoded_graphics_content", encodedGraphicsContent);
                }
                replacementMap.put("$page_number", config.getImageFileConfiguration().getDocumentPageNumber());
                replacementMap.put("$distance_from_the_left_edge", config.getImageFileConfiguration().getDistanceFromTheLeftEdge().toString());
                replacementMap.put("$distance_from_the_bottom_edge", config.getImageFileConfiguration().getDistanceFromTheBottomEdge().toString());
                replacementMap.put("$height", config.getImageFileConfiguration().getGraphicElementHeight().toString());
                replacementMap.put("$width", config.getImageFileConfiguration().getGraphicElementWidth().toString());
            }
            return replacementMap;
        }).collect(Collectors.toList());
    }

    private String getSaveSignatureEndpoint(String url) {
        String pluginPath = url.substring(0, url.lastIndexOf("config"));
        return pluginPath + "document/save?fileInformation=";
    }

    public String encodeFileInformation(SignatureFileInformation fileInformation) {
        String fileInformationText = ESignatureDocumentService.OBJECT_MAPPER.writeValueAsString((Object)fileInformation);
        return Base64Util.encodeBytesToBase64(fileInformationText.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document getXmlDocumentFromTemplate() {
        try (InputStream stream = this.getClass().getResourceAsStream("/template/task_list.xml");){
            Document document = this.xmlManager.loadXmlDocumentFromInputStream(stream);
            return document;
        }
    }

    private String getEncodedGraphicsContent(String filePath) throws IOException {
        byte[] fileContent = filePath.equals("DEFAULT_IMAGE") ? IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/resources/images/pdfGraphicSymbol.jpg"))) : FileUtils.readFileToByteArray((File)new File(filePath));
        return Base64Util.encodeBytesToBase64(fileContent);
    }

    private String updateTaskListWithUUIDs(String taskList, List<String> uuids) {
        String[] taskListChunks = taskList.split("\\$uuid_value");
        StringBuilder sb = new StringBuilder(taskListChunks[0]);
        for (int i = 1; i < taskListChunks.length; ++i) {
            sb.append(uuids.get(i - 1));
            sb.append(taskListChunks[i]);
        }
        return sb.toString();
    }

    private List<String> generateUUIDs(int size) {
        return IntStream.range(0, size).boxed().map(i -> "ID-" + UUID.randomUUID()).collect(Collectors.toList());
    }

    private TaskListData createTaskListData(String taskListText, List<String> uuids, List<FilesWithDestinationDocumentClass> filesWithDocumentClasses, FilesNumberAndSizeProperties filesProperties) {
        List wfFiles = filesWithDocumentClasses.stream().flatMap(filesWithDocumentClass -> filesWithDocumentClass.getWfFiles().stream()).collect(Collectors.toList());
        List<SummaryFileData> summaryFileDataList = IntStream.range(0, uuids.size()).boxed().map(i -> SummaryFileData.builder().uuid((String)uuids.get((int)i)).fileId(((WfFile)wfFiles.get((int)i)).getId()).fileName(((WfFile)wfFiles.get((int)i)).getFileName()).build()).collect(Collectors.toList());
        return TaskListData.builder().taskListXml(taskListText).summaryFileDataList(summaryFileDataList).filesNumberAndSizeProperties(filesProperties).build();
    }
}

