/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.esignature.configuration.controller;

import com.suncode.plugin.esignature.configuration.dto.ActionConfiguration;
import com.suncode.plugin.esignature.configuration.dto.PCMConfigurationFile;
import com.suncode.plugin.esignature.configuration.dto.TaskListData;
import com.suncode.plugin.esignature.configuration.service.ConfigurationService;
import com.suncode.pwfl.search.CountedResult;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config"})
public class ConfigurationController {
    private final ConfigurationService configurationService;

    @Autowired
    public ConfigurationController(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @RequestMapping(value={"configurationFiles"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<PCMConfigurationFile> getConfigurationFileList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        return this.configurationService.getConfigurationFiles(query, start, limit);
    }

    @RequestMapping(value={"settingsCryptoproviders"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSettingsCryptoprovidersConfig(@RequestParam String configurationName) {
        return this.configurationService.readSettingsCryptoprovidersConfiguration(configurationName);
    }

    @RequestMapping(value={"prepareTaskList"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public TaskListData prepareTaskListConfig(@RequestBody ActionConfiguration config, HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return this.configurationService.prepareTaskListConfiguration(config, url);
    }
}

