/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.services;

import com.suncode.plugin.plusenadawca.enadawca.enums.CallMethodName;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.services.ErrorLogService;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.BuforType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ClearEnvelopeResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.CreateEnvelopeBuforResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EnvelopeStatusType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ErrorType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetEnvelopeBuforListResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetEnvelopeBuforResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetEnvelopeContentFullResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetKartyResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetPrintForParcelResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KartaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PlacowkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintFormatEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintKindEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintMethodEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintResolutionEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintResultType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SendEnvelopeResponseType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SetAktywnaKartaResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.UpdateEnvelopeBuforResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.UrzadNadaniaFullType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import jakarta.xml.ws.Holder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnadawcaApiImpl
implements EnadawcaApi {
    private static final Logger log = LoggerFactory.getLogger(EnadawcaApiImpl.class);
    @Autowired
    private ErrorLogService errorLogService;

    @Override
    public List<UrzadNadaniaFullType> getOriginOfficeList(ElektronicznyNadawca nadawca) {
        return nadawca.getUrzedyNadania();
    }

    @Override
    public Optional<AddShipmentResponseItemType> addShipment(ElektronicznyNadawca nadawca, PrzesylkaType parcel, Integer bufferId) {
        List<AddShipmentResponseItemType> response = this.addShipment(nadawca, Collections.singletonList(parcel), bufferId);
        return response.stream().findAny();
    }

    @Override
    public List<AddShipmentResponseItemType> addShipment(ElektronicznyNadawca nadawca, List<PrzesylkaType> parcels, Integer bufferId) {
        List<AddShipmentResponseItemType> webServiceResponse = nadawca.addShipment(parcels, bufferId);
        webServiceResponse.stream().flatMap(response -> response.getError().stream()).forEach(error -> this.errorLogService.add((ErrorType)error, null, bufferId, CallMethodName.ADDSINGLESHIPMENT));
        return webServiceResponse;
    }

    @Override
    public ClearEnvelopeResponse clearEnvelope(ElektronicznyNadawca nadawca, Integer bufferId) {
        Holder status = new Holder();
        Holder errors = new Holder();
        nadawca.clearEnvelope(bufferId, (Holder<Boolean>)status, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, bufferId, CallMethodName.CLEARENVELOPE));
        ClearEnvelopeResponse response = new ClearEnvelopeResponse();
        response.setRetval((Boolean)status.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public SendEnvelopeResponseType sendEnvelope(ElektronicznyNadawca nadawca, Integer originOfficeId, Integer bufferId) {
        Holder idEnvelope = new Holder();
        Holder envelopeStatus = new Holder();
        Holder errors = new Holder();
        Holder envelopeFilename = new Holder();
        nadawca.sendEnvelope(originOfficeId, null, bufferId, null, (Holder<Integer>)idEnvelope, (Holder<EnvelopeStatusType>)envelopeStatus, (Holder<List<ErrorType>>)errors, (Holder<String>)envelopeFilename);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, (Integer)idEnvelope.value, bufferId, CallMethodName.SENDENVELOPE));
        SendEnvelopeResponseType response = new SendEnvelopeResponseType();
        response.setEnvelopeStatus((EnvelopeStatusType)((Object)envelopeStatus.value));
        response.setIdEnvelope((Integer)idEnvelope.value);
        response.setEnvelopeFilename((String)envelopeFilename.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public GetPrintForParcelResponse getPrintLabels(ElektronicznyNadawca nadawca, List<String> guids, PrintMethodEnum printMethodEnum, PrintKindEnum printKindEnum) {
        PrintType printType = new PrintType();
        printType.setFormat(PrintFormatEnum.PDF_FORMAT);
        printType.setResolution(PrintResolutionEnum.DPI_300);
        printType.setMethod(printMethodEnum);
        printType.setKind(printKindEnum);
        Holder printResult = new Holder();
        Holder errors = new Holder();
        nadawca.getPrintForParcel(guids, printType, (Holder<List<PrintResultType>>)printResult, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.GETPRINTLABELS));
        GetPrintForParcelResponse response = new GetPrintForParcelResponse();
        response.getPrintResult().addAll((Collection)printResult.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public PlacowkaPocztowaType getPlacowkaPocztowa(ElektronicznyNadawca nadawca, Integer pni) {
        List<PlacowkaPocztowaType> placowkaPocztowa = nadawca.getPlacowkaPocztowa(Collections.singletonList(pni));
        if (placowkaPocztowa != null && placowkaPocztowa.size() > 0) {
            return placowkaPocztowa.get(0);
        }
        return null;
    }

    @Override
    public List<PlacowkaPocztowaType> getPlacowkaPocztowa(ElektronicznyNadawca nadawca, List<Integer> pni) {
        return nadawca.getPlacowkaPocztowa(pni);
    }

    @Override
    public CreateEnvelopeBuforResponse createEnvelopeBuffer(ElektronicznyNadawca nadawca, List<BuforType> buffers) {
        Holder createdBuffers = new Holder();
        Holder errors = new Holder();
        nadawca.createEnvelopeBufor(buffers, (Holder<List<BuforType>>)createdBuffers, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.CREATEENVELOPEBUFFER));
        CreateEnvelopeBuforResponse response = new CreateEnvelopeBuforResponse();
        response.getCreatedBufor().addAll((Collection)createdBuffers.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public UpdateEnvelopeBuforResponse updateEnvelopeBuffer(ElektronicznyNadawca nadawca, List<BuforType> buffers) {
        List<ErrorType> webServiceResponse = nadawca.updateEnvelopeBufor(buffers);
        webServiceResponse.forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.UPDATEENVELOPEBUFFER));
        UpdateEnvelopeBuforResponse response = new UpdateEnvelopeBuforResponse();
        response.getError().addAll(webServiceResponse);
        return response;
    }

    @Override
    public GetEnvelopeBuforResponse getEnvelopeBuffer(ElektronicznyNadawca nadawca, Integer bufferId) {
        Holder parcels = new Holder();
        Holder errors = new Holder();
        nadawca.getEnvelopeBufor(bufferId, (Holder<List<PrzesylkaType>>)parcels, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, bufferId, CallMethodName.GETENVELOPEBUFFER));
        GetEnvelopeBuforResponse response = new GetEnvelopeBuforResponse();
        response.getPrzesylka().addAll((Collection)parcels.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public GetEnvelopeContentFullResponse getEnvelopeContentFull(ElektronicznyNadawca nadawca, Integer envelopeId) {
        GetEnvelopeContentFullResponse response = new GetEnvelopeContentFullResponse();
        response.getPrzesylka().addAll(nadawca.getEnvelopeContentFull(envelopeId));
        return response;
    }

    @Override
    public GetEnvelopeBuforListResponse getEnvelopeBufferList(ElektronicznyNadawca nadawca) {
        Holder buffers = new Holder();
        Holder errors = new Holder();
        nadawca.getEnvelopeBuforList((Holder<List<BuforType>>)buffers, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.GETENVELOPEBUFFERLIST));
        GetEnvelopeBuforListResponse response = new GetEnvelopeBuforListResponse();
        response.getBufor().addAll((Collection)buffers.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }

    @Override
    public List<BuforType> prepareBuffers(Integer[] bufferId, String[] bufferName, XMLGregorianCalendar[] postingDate, Integer[] originOfficeId, Boolean[] isActive, Boolean[] updatePostingDate, Integer[] cardId) {
        if (!ParcelCommons.checkEqualArrayLength(bufferId, bufferName, postingDate, originOfficeId, isActive, updatePostingDate)) {
            throw new IllegalArgumentException("Arrays must be equal in size!");
        }
        return IntStream.range(0, bufferId.length).mapToObj(i -> {
            BuforType buforType = new BuforType();
            buforType.setIdBufor(bufferId[i]);
            buforType.setOpis(bufferName[i]);
            buforType.setDataNadania(postingDate[i]);
            buforType.setUrzadNadania(originOfficeId[i]);
            buforType.setActive(isActive[i]);
            buforType.setAktualizujPlanowanaDateNadaniaPrzesylek(updatePostingDate[i]);
            if (cardId != null && i < cardId.length) {
                buforType.setIdKarta(cardId[i]);
            }
            return buforType;
        }).toList();
    }

    @Override
    public SetAktywnaKartaResponse setActiveCard(ElektronicznyNadawca nadawca, Integer cardId) {
        List<ErrorType> errorTypes = nadawca.setAktywnaKarta(cardId);
        List<ErrorType> webServiceResponse = nadawca.setAktywnaKarta(cardId);
        webServiceResponse.forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.SETACTIVECARD));
        SetAktywnaKartaResponse response = new SetAktywnaKartaResponse();
        response.getError().addAll(webServiceResponse);
        return response;
    }

    @Override
    public GetKartyResponse getCards(ElektronicznyNadawca nadawca) {
        Holder cards = new Holder();
        Holder errors = new Holder();
        nadawca.getKarty(Collections.emptyList(), (Holder<List<KartaType>>)cards, (Holder<List<ErrorType>>)errors);
        ((List)errors.value).forEach(error -> this.errorLogService.add((ErrorType)error, null, null, CallMethodName.GETCARDS));
        GetKartyResponse response = new GetKartyResponse();
        response.getKarta().addAll((Collection)cards.value);
        response.getError().addAll((Collection)errors.value);
        return response;
    }
}

