/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.scheduledtasks;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SendEnvelopeResponseType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/enadawca/scheduledtasks/SendEnvelope/pwe_dynamic_form.js")
public class SendEnvelope
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(SendEnvelope.class);
    @Autowired
    ActivityFinder activityFinder;
    @Autowired
    ProcessFinder processFinder;
    @Autowired
    ActivityService activityService;
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusenadawca.enadawca.scheduledtasks.SendEnvelope")).name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.name")).description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.SEND)).parameter().id("configId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("originOfficeId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.originOfficeId.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.originOfficeId.desc").type((Type)Types.STRING).create()).parameter().id("bufferId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.bufferId.name").type((Type)Types.INTEGER).optional().create()).parameter().id("envelopeIdVariableId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.envelopeIdVariableId.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.envelopeIdVariableId.desc").type((Type)Types.STRING).optional().create()).parameter().id("processDefinitionId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.processDefinitionId.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.processDefinitionId.desc").type((Type)Types.STRING).optional().create()).parameter().id("activityDefinitionId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.activityDefinitionId.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.activityDefinitionId.desc").type((Type)Types.STRING).optional().create()).parameter().id("actionName").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.actionName.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.actionName.desc").type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param String configId, @Param String originOfficeId, @Param Integer bufferId, @Param String envelopeIdVariableId, @Param String processDefinitionId, @Param String activityDefinitionId, @Param String actionName, org.apache.log4j.Logger logger) {
        try {
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            SendEnvelopeResponseType response = this.enadawcaApi.sendEnvelope(nadawca, Integer.valueOf(originOfficeId), bufferId);
            if (!response.getError().isEmpty()) {
                return response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{envelopeIdVariableId, processDefinitionId, activityDefinitionId, actionName})) {
                List<Activity> activities = this.findOpenActivities(processDefinitionId, activityDefinitionId);
                logger.debug((Object)("Found " + activities.size() + " open activities"));
                this.updateActivity(activities, actionName, envelopeIdVariableId, response.getIdEnvelope());
            }
            return "Successfully sent default envelope!";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Error sending envelope: " + e.getMessage();
        }
    }

    private void updateActivity(List<Activity> activities, String actionName, String envelopeIdVariableId, Integer envelopeId) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        for (Activity activity : activities) {
            Map activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            activityContext.put(envelopeIdVariableId, envelopeId);
            this.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionName);
        }
    }

    public List<Activity> findOpenActivities(String processDefinitionId, String activityDefinitionId) {
        return this.processFinder.findByProcessDefinitionId(processDefinitionId).stream().filter(process -> process.getState() == ProcessState.RUNNING || process.getState() == ProcessState.NOT_STARTED).map(Process::getProcessId).map(processId -> this.activityFinder.findOpenedActivities(processId).stream().filter(activity -> activity.isOpen() && activity.getActivityDefinitionId().equals(activityDefinitionId)).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public void acceptActivity(String processId, String activityId, Map<String, Object> activityContextMap, String actionName) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        String executorLogin = SystemProperties.getString((String)"Bufor.username");
        this.activityService.openActivity(executorLogin, processId, activityId);
        AcceptationDefinition acceptationDef = new AcceptationDefinition(processId, activityId, executorLogin, actionName);
        acceptationDef.setIgnoreOwnerShip(Boolean.valueOf(true));
        acceptationDef.setIgnoreValidators(Boolean.valueOf(false));
        acceptationDef.setContextMap(activityContextMap);
        this.activityService.acceptActivity(acceptationDef);
    }
}

