/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ObszarType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021NaDzisType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/Pocztex2021Today/pwe_dynamic_form.js")
public class Pocztex2021Today {
    private static final Logger log = LoggerFactory.getLogger(Pocztex2021Today.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.Pocztex2021Today")).name("plusenadawca.enadawca.autotasks.Pocztex2021Today.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            Pocztex2021NaDzisType parcel = this.createPocztex2021TodayParcel(valueParams, functionParams);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Pocztex2021NaDzisType createPocztex2021TodayParcel(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        Pocztex2021NaDzisType pocztex2021NaDzisType = new Pocztex2021NaDzisType();
        ParcelCommons.fillPocztex2021Parameters(pocztex2021NaDzisType, valueParams, functionParams);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("odleglosc", valueParams, functionParams, Integer.class), pocztex2021NaDzisType::setOdleglosc);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("obszar", valueParams, functionParams, String.class), ObszarType::valueOf, pocztex2021NaDzisType::setObszar);
        return pocztex2021NaDzisType;
    }
}

