/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GodzinaDoreczeniaPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PlacowkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021KurierType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PunktNadaniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PunktOdbioruType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ShipmentChannelPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/Pocztex2021Carrier/pwe_dynamic_form.js")
public class Pocztex2021Carrier {
    private static final Logger log = LoggerFactory.getLogger(Pocztex2021Carrier.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.Pocztex2021Carrier")).name("plusenadawca.enadawca.autotasks.Pocztex2021Carrier.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Pocztex2021KurierType parcel = this.createPocztex2021CarrierParcel(nadawca, valueParams, functionParams);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Pocztex2021KurierType createPocztex2021CarrierParcel(ElektronicznyNadawca nadawca, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        Pocztex2021KurierType pocztex2021KurierType = new Pocztex2021KurierType();
        ParcelCommons.fillPocztex2021Parameters(pocztex2021KurierType, valueParams, functionParams);
        if (ParcelCommons.extractValue("punktOdbioru", valueParams, functionParams) != null) {
            PlacowkaPocztowaType punktOdbioruPlacowka = this.enadawcaApi.getPlacowkaPocztowa(nadawca, ParcelCommons.extractValue("punktOdbioru", valueParams, functionParams, Integer.class));
            PunktOdbioruType punktOdbioru = ParcelCommons.castPostOfficeType(punktOdbioruPlacowka, PunktOdbioruType.class);
            pocztex2021KurierType.setPunktOdbioru(punktOdbioru);
        }
        if (ParcelCommons.extractValue("punktNadania", valueParams, functionParams) != null) {
            PlacowkaPocztowaType punktNadaniaPlacowka = this.enadawcaApi.getPlacowkaPocztowa(nadawca, ParcelCommons.extractValue("punktNadania", valueParams, functionParams, Integer.class));
            PunktNadaniaType punktNadania = ParcelCommons.castPostOfficeType(punktNadaniaPlacowka, PunktNadaniaType.class);
            pocztex2021KurierType.setPunktNadania(punktNadania);
        }
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("kopertaPocztex", valueParams, functionParams), pocztex2021KurierType::setKopertaPocztex);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("godzinaDoreczenia", valueParams, functionParams, String.class), GodzinaDoreczeniaPocztex2021Enum::valueOf, pocztex2021KurierType::setGodzinaDoreczenia);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("doreczenieWeWskazanymDniu", valueParams, functionParams, LocalDate.class), ParcelCommons::getGregorianCalendarDate, pocztex2021KurierType::setDoreczenieWeWskazanymDniu);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("labelExpirationDate", valueParams, functionParams, LocalDate.class), ParcelCommons::getGregorianCalendarDate, pocztex2021KurierType::setLabelExpirationDate);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("shipmentChannel", valueParams, functionParams, String.class), ShipmentChannelPocztex2021Enum::valueOf, pocztex2021KurierType::setShipmentChannel);
        return pocztex2021KurierType;
    }
}

