/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracjaCelna2Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaZadeklarowanaWartoscZagranicznaType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/InternationalDeclaredValueParcel/pwe_dynamic_form.js")
public class InternationalDeclaredValueParcel {
    private static final Logger log = LoggerFactory.getLogger(InternationalDeclaredValueParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.InternationalDeclaredValueParcel")).name("plusenadawca.enadawca.autotasks.InternationalDeclaredValueParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            PrzesylkaZadeklarowanaWartoscZagranicznaType parcel = this.createInternationalDeclaredValueParcel(valueParams, functionParams);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaZadeklarowanaWartoscZagranicznaType createInternationalDeclaredValueParcel(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        PrzesylkaZadeklarowanaWartoscZagranicznaType przesylkaZadeklarowanaWartoscZagranicznaType = new PrzesylkaZadeklarowanaWartoscZagranicznaType();
        ParcelCommons.fillRegisteredShipmentParameters(przesylkaZadeklarowanaWartoscZagranicznaType, valueParams, functionParams);
        Optional<DeklaracjaCelna2Type> deklaracjaCelna2Type = ParcelCommons.fillCustomsDeclarationType(valueParams, functionParams);
        deklaracjaCelna2Type.ifPresent(przesylkaZadeklarowanaWartoscZagranicznaType::setDeklaracjaCelna2);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("posteRestante", valueParams, functionParams), przesylkaZadeklarowanaWartoscZagranicznaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("masa", valueParams, functionParams, Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setMasa);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("iloscPotwierdzenOdbioru", valueParams, functionParams, Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("wartosc", valueParams, functionParams, Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setWartosc);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("zawartosc", valueParams, functionParams), przesylkaZadeklarowanaWartoscZagranicznaType::setZawartosc);
        return przesylkaZadeklarowanaWartoscZagranicznaType;
    }
}

