/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AdresType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ListZwyklyFirmowyType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/CommercialNonRegisteredDomesticParcel/pwe_dynamic_form.js")
public class CommercialNonRegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(CommercialNonRegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.CommercialNonRegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.CommercialNonRegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            ListZwyklyFirmowyType parcel = this.createCommercialNonRegisteredDomesticParcel(valueParams, functionParams);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private ListZwyklyFirmowyType createCommercialNonRegisteredDomesticParcel(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        ListZwyklyFirmowyType listZwyklyFirmowyType = new ListZwyklyFirmowyType();
        ParcelCommons.fillNonRegisteredShipmentParameters(listZwyklyFirmowyType, valueParams, functionParams);
        Optional<AdresType> senderAddress = ParcelCommons.fillAddressType(valueParams, functionParams, "receiverAddress");
        senderAddress.ifPresent(listZwyklyFirmowyType::setAdres);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("posteRestante", valueParams, functionParams), listZwyklyFirmowyType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("masa", valueParams, functionParams, Integer.class), listZwyklyFirmowyType::setMasa);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("gabaryt", valueParams, functionParams, String.class), GabarytType::valueOf, listZwyklyFirmowyType::setGabaryt);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("kategoria", valueParams, functionParams, String.class), KategoriaType::valueOf, listZwyklyFirmowyType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("miejscowa", valueParams, functionParams), listZwyklyFirmowyType::setMiejscowa);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("obszarMiasto", valueParams, functionParams), listZwyklyFirmowyType::setObszarMiasto);
        return listZwyklyFirmowyType;
    }
}

