/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetPrintForParcelResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintFormatEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintKindEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintMethodEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/GetPrintLabels/pwe_dynamic_form.js")
public class GetPrintLabels {
    private static final Logger log = LoggerFactory.getLogger(GetPrintLabels.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;
    @Autowired
    private DocumentService documentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.GetPrintLabels")).name("plusenadawca.enadawca.autotasks.GetPrintLabels.name")).description("plusenadawca.enadawca.autotasks.GetPrintLabels.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("configId").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("guids").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.guids.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.guids.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("printMethodName").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printMethodName.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printMethodName.desc").type((Type)Types.STRING).create()).parameter().id("printKindName").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printKindName.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printKindName.desc").type((Type)Types.STRING).create()).parameter().id("printFormatName").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printFormatName.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.printFormatName.desc").type((Type)Types.STRING).defaultValue((Object)PrintFormatEnum.PDF_FORMAT.name()).create()).parameter().id("documentClassName").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.documentClassName.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("docName").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.docName.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.docName.desc").type((Type)Types.STRING).create()).parameter().id("docDescription").name("plusenadawca.enadawca.autotasks.GetPrintLabels.param.docDescription.name").description("plusenadawca.enadawca.autotasks.GetPrintLabels.param.docDescription.desc").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext appContext, Parameters params, UserInfo userInfo) throws AcceptanceException {
        try {
            String[] guids = (String[])params.get("guids", String[].class);
            PrintMethodEnum printMethodEnum = PrintMethodEnum.valueOf((String)params.get("printMethodName", String.class));
            PrintKindEnum printKindEnum = PrintKindEnum.valueOf((String)params.get("printKindName", String.class));
            String documentClassName = (String)params.get("documentClassName", String.class);
            String filename = this.getFilename((String)params.get("docName", String.class), PrintFormatEnum.valueOf((String)params.get("printFormatName", String.class)));
            String docDescription = (String)params.get("docDescription", String.class);
            String configId = (String)params.get("configId", String.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            GetPrintForParcelResponse response = this.enadawcaApi.getPrintLabels(nadawca, Arrays.asList(guids), printMethodEnum, printKindEnum);
            if (!response.getError().isEmpty()) {
                throw new AcceptanceException(response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
            }
            Long documentClassId = ServiceFactory.getDocumentClassService().getDocumentClass(documentClassName, new String[0]).getId();
            response.getPrintResult().forEach(label -> this.addDocument(label.getPrint(), documentClassId, filename, docDescription, userInfo.getUserName(), appContext.getProcessId()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private String getFilename(String documentName, PrintFormatEnum printFormatEnum) {
        documentName = printFormatEnum.equals((Object)PrintFormatEnum.ZPL_FORMAT) ? documentName.concat(".zpl") : documentName.concat(".pdf");
        return documentName;
    }

    private void addDocument(byte[] data, Long docClassId, String fileName, String description, String userName, String processId) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(docClassId);
        documentDefinition.setFileName(fileName);
        documentDefinition.setDescription(description);
        documentDefinition.setUserName(userName);
        documentDefinition.setProcessId(processId);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(data));
        this.documentService.addDocument(documentDefinition);
    }
}

