/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetEnvelopeContentFullResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaFullType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/GetEnvelopeContentFull/pwe_dynamic_form.js")
public class GetEnvelopeContentFull {
    private static final Logger log = LoggerFactory.getLogger(GetEnvelopeContentFull.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull")).name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.name")).description("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.LIST)).parameter().id("configId").name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("envelopeId").name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.envelopeId.name").type((Type)Types.INTEGER).create()).parameter().id("postingNumberVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.postingNumberVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.postingNumberVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("guidVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.guidVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.guidVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("postingDateVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.postingDateVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeContentFull.param.postingDateVariable.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String configId, @Param Integer envelopeId, @Param Variable postingNumberVariable, @Param Variable guidVariable, @Param Variable postingDateVariable) throws AcceptanceException {
        try {
            if (!ParcelCommons.checkArrayType(postingNumberVariable, guidVariable, postingDateVariable)) {
                throw new AcceptanceException("Expecting array type variables!");
            }
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            GetEnvelopeContentFullResponse envelopeContentFull = this.enadawcaApi.getEnvelopeContentFull(nadawca, envelopeId);
            List<PrzesylkaFullType> parcels = envelopeContentFull.getPrzesylka();
            String[] guidArray = new String[parcels.size()];
            String[] postingNumberArray = new String[parcels.size()];
            LocalDate[] postingDateArray = new LocalDate[parcels.size()];
            for (int i = 0; i < parcels.size(); ++i) {
                PrzesylkaFullType parcel = parcels.get(i);
                guidArray[i] = parcel.getPrzesylkaShort().getGuid();
                postingNumberArray[i] = parcel.getPrzesylkaShort().getNumerNadania();
            }
            guidVariable.setValue((Object)guidArray);
            postingNumberVariable.setValue((Object)postingNumberArray);
            postingDateVariable.setValue((Object)postingDateArray);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

