/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.utils;

import com.suncode.plugin.plusenadawca.enadawca.enums.FormatPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AdresType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracaCelnaRodzajEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracjaCelna2Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DokumentTowarzyszacyRodzajEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DokumentyTowarzyszaceType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ESposobPowiadomieniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ErrorType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PlacowkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PobranieType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PotwierdzenieEDoreczeniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PotwierdzenieOdbioruPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaNieRejestrowanaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaRejestrowanaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobDoreczeniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobPobraniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobPrzekazaniaPotwierdzeniaOdbioruPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobZwrotuType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SzczegolyZawartosciPrzesylkiZagranicznejType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.UbezpieczenieType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscPrzesylkiZagranicznejEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscSpecjalnaEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZwrotDokumentowPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZwrotType;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalDate;

public class ParcelCommons {
    public static AdresType getAdresType(Parameters parameters) {
        AdresType adresType = new AdresType();
        adresType.setNazwa((String)parameters.get("nazwa", String.class));
        adresType.setNazwa2((String)parameters.get("nazwa2", String.class));
        adresType.setUlica((String)parameters.get("ulica", String.class));
        adresType.setNumerDomu((String)parameters.get("numerDomu", String.class));
        adresType.setNumerLokalu((String)parameters.get("numerLokalu", String.class));
        adresType.setMiejscowosc((String)parameters.get("miejscowosc", String.class));
        adresType.setKodPocztowy((String)parameters.get("kodPocztowy", String.class));
        adresType.setTelefon((String)parameters.get("telefon", String.class));
        adresType.setEmail((String)parameters.get("email", String.class));
        adresType.setMobile((String)parameters.get("mobile", String.class));
        adresType.setOsobaKontaktowa((String)parameters.get("osobaKontaktowa", String.class));
        return adresType;
    }

    public static EPOType getEpoType(Boolean extended) {
        return Boolean.TRUE.equals(extended) ? new EPOExtendedType() : new EPOSimpleType();
    }

    public static void processShipment(AddShipmentResponseItemType shipmentResponseItem, Variable resultShipmentNumberVariable, Variable resultGuidNumberVariable) throws AcceptanceException {
        if (!shipmentResponseItem.getError().isEmpty()) {
            throw new AcceptanceException(shipmentResponseItem.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
        }
        resultShipmentNumberVariable.setValue((Object)shipmentResponseItem.getNumerNadania());
        resultGuidNumberVariable.setValue((Object)shipmentResponseItem.getGuid());
    }

    public static Optional<AdresType> fillAddressType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams, String parameterIdPrefix) {
        boolean shouldSet = false;
        AdresType adresType = new AdresType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".nazwa", valueParams, functionParams), adresType::setNazwa);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".nazwa2", valueParams, functionParams), adresType::setNazwa2);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".ulica", valueParams, functionParams), adresType::setUlica);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".numerDomu", valueParams, functionParams), adresType::setNumerDomu);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".numerLokalu", valueParams, functionParams), adresType::setNumerLokalu);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".miejscowosc", valueParams, functionParams), adresType::setMiejscowosc);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".kodPocztowy", valueParams, functionParams), adresType::setKodPocztowy);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".kraj", valueParams, functionParams), adresType::setKraj);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".telefon", valueParams, functionParams), adresType::setTelefon);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".email", valueParams, functionParams), adresType::setEmail);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".mobile", valueParams, functionParams), adresType::setMobile);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".osobaKontaktowa", valueParams, functionParams), adresType::setOsobaKontaktowa);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue(parameterIdPrefix + ".nip", valueParams, functionParams), adresType::setNip)) {
            return Optional.of(adresType);
        }
        return Optional.empty();
    }

    public static LocalDate getLocalDate(XMLGregorianCalendar gregorianDate) {
        return new LocalDate((Object)gregorianDate.toGregorianCalendar().getTime());
    }

    public static XMLGregorianCalendar getGregorianCalendarDate(LocalDate date) {
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(date.toString());
    }

    public static XMLGregorianCalendar[] getGregorianCalendarDate(LocalDate[] dates) {
        XMLGregorianCalendar[] gregorianCalendarDates = new XMLGregorianCalendar[dates.length];
        for (int i = 0; i < gregorianCalendarDates.length; ++i) {
            gregorianCalendarDates[i] = ParcelCommons.getGregorianCalendarDate(dates[i]);
        }
        return gregorianCalendarDates;
    }

    public static boolean checkForEmptyArray(Object[] ... arrays) {
        return Stream.of(arrays).anyMatch(array -> array == null || ((Object[])array).length == 0);
    }

    public static boolean checkArrayType(Variable ... arrays) {
        return Stream.of(arrays).allMatch(Variable::isArray);
    }

    public static boolean checkEqualArrayLength(Object[] ... arrays) {
        if (arrays.length == 0) {
            return true;
        }
        int targetSize = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].length == targetSize) continue;
            return false;
        }
        return true;
    }

    public static String errorTypeToString(ErrorType error) {
        return String.format("Error! %d: %s", error.getErrorNumber(), error.getErrorDesc());
    }

    public static void fillMainShipmentParameters(PrzesylkaType parcel, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        parcel.setGuid(UUID.randomUUID().toString());
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("mainShipment.mpk", valueParams, functionParams), parcel::setMpk);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("mainShipment.pakietGuid", valueParams, functionParams), parcel::setPakietGuid);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("mainShipment.opakowanieGuid", valueParams, functionParams), parcel::setOpakowanieGuid);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("mainShipment.opis", valueParams, functionParams), parcel::setOpis);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("mainShipment.planowanaDataNadania", valueParams, functionParams, LocalDate.class), ParcelCommons::getGregorianCalendarDate, parcel::setPlanowanaDataNadania);
    }

    public static void fillRegisteredShipmentParameters(PrzesylkaRejestrowanaType parcel, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        Optional<AdresType> senderAddress = ParcelCommons.fillAddressType(valueParams, functionParams, "receiverAddress");
        senderAddress.ifPresent(parcel::setAdres);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("registeredShipment.numerNadania", valueParams, functionParams), parcel::setNumerNadania);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("registeredShipment.sygnatura", valueParams, functionParams), parcel::setSygnatura);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("registeredShipment.terminSprawy", valueParams, functionParams), parcel::setTerminSprawy);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("registeredShipment.rodzaj", valueParams, functionParams), parcel::setRodzaj);
        ParcelCommons.fillMainShipmentParameters(parcel, valueParams, functionParams);
    }

    public static void fillNonRegisteredShipmentParameters(PrzesylkaNieRejestrowanaType parcel, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("nonRegisteredShipment.ilosc", valueParams, functionParams, Integer.class), parcel::setIlosc);
        ParcelCommons.fillMainShipmentParameters(parcel, valueParams, functionParams);
    }

    public static <T> T extractValue(String key, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        if (valueParams.containsKey(key)) {
            return (T)valueParams.get(key).getValue();
        }
        if (functionParams.containsKey(key)) {
            return (T)functionParams.get(key).call();
        }
        return null;
    }

    public static void fillPocztex2021Parameters(Pocztex2021Type parcel, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        Optional<PobranieType> pobranieType = ParcelCommons.fillCashOnDeliveryType(valueParams, functionParams);
        pobranieType.ifPresent(parcel::setPobranie);
        Optional<PotwierdzenieEDoreczeniaType> potwierdzenieEDoreczeniaType = ParcelCommons.fillDeliveryConfirmationType(valueParams, functionParams);
        potwierdzenieEDoreczeniaType.ifPresent(parcel::setPotwierdzenieDoreczenia);
        Optional<PotwierdzenieOdbioruPocztex2021Type> potwierdzenieOdbioruPocztex2021Type = ParcelCommons.fillReceivingConfirmationType(valueParams, functionParams);
        potwierdzenieOdbioruPocztex2021Type.ifPresent(parcel::setPotwierdzenieOdbioru);
        Optional<UbezpieczenieType> ubezpieczenieType = ParcelCommons.fillInsuranceType(valueParams, functionParams);
        ubezpieczenieType.ifPresent(parcel::setUbezpieczenie);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.masa", valueParams, functionParams, Integer.class), parcel::setMasa);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.wartosc", valueParams, functionParams, Integer.class), parcel::setWartosc);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("pocztex2021.ostroznie", valueParams, functionParams), parcel::setOstroznie);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("pocztex2021.ponadGabaryt", valueParams, functionParams), parcel::setPonadgabaryt);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("pocztex2021.format", valueParams, functionParams), FormatPocztex2021Type::getValueString, parcel::setFormat);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("pocztex2021.numerPrzesylkiKlienta", valueParams, functionParams), parcel::setNumerPrzesylkiKlienta);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.zwrotDokumentow", valueParams, functionParams, String.class), ZwrotDokumentowPocztex2021Enum::valueOf, parcel::setZwrotDokumentow);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.idDokumentyZwrotneAdresy", valueParams, functionParams, Integer.class), parcel::setIdDokumentyZwrotneAdresy);
        if (Boolean.TRUE.equals(ParcelCommons.extractValue("epo.podstawowe", valueParams, functionParams))) {
            parcel.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(ParcelCommons.extractValue("epo.rozszerzone", valueParams, functionParams))) {
            parcel.setEpo(new EPOExtendedType());
        }
        Optional<AdresType> adresType = ParcelCommons.fillAddressType(valueParams, functionParams, "returnAddress");
        adresType.ifPresent(parcel::setAdresDlaZwrotu);
        Optional<ZawartoscPocztex2021Type> zawartoscPocztex2021Type = ParcelCommons.fillPocztex2021ContentType(valueParams, functionParams);
        zawartoscPocztex2021Type.ifPresent(parcel::setZawartosc);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.zasadySpecjalne", valueParams, functionParams, String.class), ZasadySpecjalneEnum::valueOf, parcel::setZasadySpecjalne);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("pocztex2021.odbiorWSobote", valueParams, functionParams), parcel::setOdbiorWSobote);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("pocztex2021.sprawdzenieZawartosciPrzesylkiPrzezOdbiorce", valueParams, functionParams), parcel::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("pocztex2021.doreczenieDoRakWlasnych", valueParams, functionParams), parcel::setDoreczenieDoRakWlasnych);
        ParcelCommons.fillRegisteredShipmentParameters(parcel, valueParams, functionParams);
    }

    public static Optional<ZawartoscPocztex2021Type> fillPocztex2021ContentType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        ZawartoscPocztex2021Type zawartoscPocztex2021Type = new ZawartoscPocztex2021Type();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("pocztex2021.zawartoscSpecjalna", valueParams, functionParams, String.class), ZawartoscSpecjalnaEnum::valueOf, zawartoscPocztex2021Type::setZawartoscSpecjalna);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("pocztex2021.zawartoscInna", valueParams, functionParams), zawartoscPocztex2021Type::setZawartoscInna)) {
            return Optional.of(zawartoscPocztex2021Type);
        }
        return Optional.empty();
    }

    public static Optional<UbezpieczenieType> fillInsuranceType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        UbezpieczenieType ubezpieczenieType = new UbezpieczenieType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("insurance.rodzaj", valueParams, functionParams), ubezpieczenieType::setRodzaj);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("insurance.kwota", valueParams, functionParams, Float.class), BigDecimal::valueOf, ubezpieczenieType::setKwota)) {
            return Optional.of(ubezpieczenieType);
        }
        return Optional.empty();
    }

    public static Optional<PobranieType> fillCashOnDeliveryType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        PobranieType pobranieType = new PobranieType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("cashOnDelivery.sposobPobrania", valueParams, functionParams, String.class), SposobPobraniaType::valueOf, pobranieType::setSposobPobrania);
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("cashOnDelivery.kwotaPobrania", valueParams, functionParams, Integer.class), pobranieType::setKwotaPobrania);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("cashOnDelivery.nrb", valueParams, functionParams), pobranieType::setNrb);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("cashOnDelivery.tytulem", valueParams, functionParams), pobranieType::setTytulem)) {
            return Optional.of(pobranieType);
        }
        return Optional.empty();
    }

    public static Optional<ZwrotType> fillReturnType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        ZwrotType zwrotType = new ZwrotType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("return.sposobZwrotu", valueParams, functionParams, String.class), SposobZwrotuType::valueOf, zwrotType::setSposobZwrotu);
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("return.zwrotPoLiczbieDni", valueParams, functionParams, Integer.class), zwrotType::setZwrotPoLiczbieDni);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("return.traktowacJakPorzucona", valueParams, functionParams), zwrotType::setTraktowacJakPorzucona)) {
            return Optional.of(zwrotType);
        }
        return Optional.empty();
    }

    public static Optional<SposobDoreczeniaType> fillDeliveryModeType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        SposobDoreczeniaType sposobDoreczeniaType = new SposobDoreczeniaType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("deliveryMode.sposobDoreczeniaKod", valueParams, functionParams), sposobDoreczeniaType::setKod);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("deliveryMode.identyfikatorPunktuOdbioru", valueParams, functionParams), sposobDoreczeniaType::setIdentyfikatorPunktuOdbioru)) {
            return Optional.of(sposobDoreczeniaType);
        }
        return Optional.empty();
    }

    public static Optional<DeklaracjaCelna2Type> fillCustomsDeclarationType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        DeklaracjaCelna2Type deklaracjaCelna2Type = new DeklaracjaCelna2Type();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("customsDeclaration.deklaracjaCelnaRodzaj", valueParams, functionParams, String.class), DeklaracaCelnaRodzajEnum::valueOf, deklaracjaCelna2Type::setRodzaj);
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("customsDeclaration.zawartoscPrzesylki", valueParams, functionParams, String.class), ZawartoscPrzesylkiZagranicznejEnum::valueOf, deklaracjaCelna2Type::setZawartoscPrzesylki);
        ArrayList dokumentyTowarzyszaceTypes = new ArrayList();
        String[] dokumentyTowarzyszaceNumer = (String[])ParcelCommons.extractValue("customsDeclaration.dokumentyTowarzyszaceNumer", valueParams, functionParams);
        String[] dokumentyTowarzyszaceRodzaj = (String[])ParcelCommons.extractValue("customsDeclaration.dokumentyTowarzyszaceRodzaj", valueParams, functionParams);
        shouldSet |= !ParcelCommons.checkForEmptyArray(dokumentyTowarzyszaceNumer, dokumentyTowarzyszaceRodzaj);
        if (dokumentyTowarzyszaceNumer != null) {
            IntStream.range(0, dokumentyTowarzyszaceNumer.length).forEach(indeks -> {
                DokumentyTowarzyszaceType dokumentyTowarzyszaceType = new DokumentyTowarzyszaceType();
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(dokumentyTowarzyszaceNumer, indeks), dokumentyTowarzyszaceType::setNumer);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(dokumentyTowarzyszaceRodzaj, indeks), DokumentTowarzyszacyRodzajEnum::valueOf, dokumentyTowarzyszaceType::setRodzaj);
                dokumentyTowarzyszaceTypes.add(dokumentyTowarzyszaceType);
            });
            deklaracjaCelna2Type.getDokumentyTowarzyszace().addAll(dokumentyTowarzyszaceTypes);
        }
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.wyjasnienie", valueParams, functionParams), deklaracjaCelna2Type::setWyjasnienie);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.oplatyPocztowe", valueParams, functionParams), deklaracjaCelna2Type::setOplatyPocztowe);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.uwagi", valueParams, functionParams), deklaracjaCelna2Type::setUwagi);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.numerReferencyjnyImportera", valueParams, functionParams), deklaracjaCelna2Type::setNumerReferencyjnyImportera);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.numerTelefonuImportera", valueParams, functionParams), deklaracjaCelna2Type::setNumerTelefonuImportera);
        shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.walutaKodISO", valueParams, functionParams), deklaracjaCelna2Type::setWalutaKodISO);
        ArrayList szczegolyZawartosciPrzesylkiZagranicznejTypes = new ArrayList();
        String[] okreslenieZawartosci = (String[])ParcelCommons.extractValue("customsDeclaration.okreslenieZawartosci", valueParams, functionParams);
        Integer[] szczegolyZawartosciIlosc = ParcelCommons.extractValue("customsDeclaration.szczegolyZawartosciIlosc", valueParams, functionParams, Integer[].class);
        Integer[] masaNetto = ParcelCommons.extractValue("customsDeclaration.masaNetto", valueParams, functionParams, Integer[].class);
        Float[] szczegolyZawartosciWartosc = ParcelCommons.extractValue("customsDeclaration.szczegolyZawartosciWartosc", valueParams, functionParams, Float[].class);
        String[] numerTaryfyHs = (String[])ParcelCommons.extractValue("customsDeclaration.numerTaryfyHs", valueParams, functionParams);
        String[] krajPochodzeniaKodAlfa2 = (String[])ParcelCommons.extractValue("customsDeclaration.krajPochodzeniaKodAlfa2", valueParams, functionParams);
        shouldSet |= !ParcelCommons.checkForEmptyArray(okreslenieZawartosci, szczegolyZawartosciIlosc, masaNetto, szczegolyZawartosciWartosc, numerTaryfyHs, krajPochodzeniaKodAlfa2);
        if (okreslenieZawartosci != null) {
            IntStream.range(0, okreslenieZawartosci.length).forEach(indeks -> {
                SzczegolyZawartosciPrzesylkiZagranicznejType szczegolyZawartosciPrzesylkiZagranicznejType = new SzczegolyZawartosciPrzesylkiZagranicznejType();
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(okreslenieZawartosci, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setOkreslenieZawartosci);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(szczegolyZawartosciIlosc, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setIlosc);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(masaNetto, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setMasaNetto);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(szczegolyZawartosciWartosc, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setWartosc);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(numerTaryfyHs, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setNumerTaryfyHs);
                ParcelCommons.setIfNotNull(() -> ParcelCommons.getValueAt(krajPochodzeniaKodAlfa2, indeks), szczegolyZawartosciPrzesylkiZagranicznejType::setKrajPochodzeniaKodAlfa2);
                szczegolyZawartosciPrzesylkiZagranicznejTypes.add(szczegolyZawartosciPrzesylkiZagranicznejType);
            });
            deklaracjaCelna2Type.getSzczegolyZawartosciPrzesylki().addAll(szczegolyZawartosciPrzesylkiZagranicznejTypes);
        }
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("customsDeclaration.numerReferencyjnyCelny", valueParams, functionParams), deklaracjaCelna2Type::setNumerReferencyjnyCelny)) {
            return Optional.of(deklaracjaCelna2Type);
        }
        return Optional.empty();
    }

    public static Optional<PotwierdzenieEDoreczeniaType> fillDeliveryConfirmationType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        PotwierdzenieEDoreczeniaType potwierdzenieEDoreczeniaType = new PotwierdzenieEDoreczeniaType();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("deliveryConfirmation.potwierdzenieDoreczeniaSposob", valueParams, functionParams, String.class), ESposobPowiadomieniaType::valueOf, potwierdzenieEDoreczeniaType::setSposob);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("deliveryConfirmation.potwierdzenieDoreczeniaKontakt", valueParams, functionParams), potwierdzenieEDoreczeniaType::setKontakt)) {
            return Optional.of(potwierdzenieEDoreczeniaType);
        }
        return Optional.empty();
    }

    public static Optional<PotwierdzenieOdbioruPocztex2021Type> fillReceivingConfirmationType(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        boolean shouldSet = false;
        PotwierdzenieOdbioruPocztex2021Type potwierdzenieOdbioruPocztex2021Type = new PotwierdzenieOdbioruPocztex2021Type();
        shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("receivingConfirmation.potwierdzenieOdbioruIlosc", valueParams, functionParams, Integer.class), potwierdzenieOdbioruPocztex2021Type::setIlosc);
        if (shouldSet |= ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("receivingConfirmation.potwierdzenieOdbioruSposob", valueParams, functionParams, String.class), SposobPrzekazaniaPotwierdzeniaOdbioruPocztex2021Enum::valueOf, potwierdzenieOdbioruPocztex2021Type::setSposobPotwierdzeniaOdbioru)) {
            return Optional.of(potwierdzenieOdbioruPocztex2021Type);
        }
        return Optional.empty();
    }

    public static <T extends PlacowkaPocztowaType> T castPostOfficeType(PlacowkaPocztowaType source, Class<T> targetClass) {
        try {
            PlacowkaPocztowaType target = (PlacowkaPocztowaType)targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : PlacowkaPocztowaType.class.getDeclaredFields()) {
                field.setAccessible(true);
                field.set(target, field.get(source));
            }
            return (T)target;
        }
        catch (Exception e) {
            throw new RuntimeException("Post Office casting failed", e);
        }
    }

    public static <V> boolean setIfNotNull(Supplier<V> supplier, Consumer<V> setter) {
        V value = supplier.get();
        if (value != null) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static <V, R> boolean setIfNotNull(Supplier<V> supplier, Function<V, R> converter, Consumer<R> setter) {
        V rawValue = supplier.get();
        if (rawValue != null) {
            R value = converter.apply(rawValue);
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static <T> T extractValue(String key, Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams, Class<T> type) {
        Object value = null;
        if (valueParams.containsKey(key)) {
            value = valueParams.get(key).getValue();
        } else if (functionParams.containsKey(key)) {
            value = functionParams.get(key).call();
        }
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                Object convertedArray = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(value, i);
                    Object converted = ParcelCommons.convertValue(element, componentType);
                    Array.set(convertedArray, i, converted);
                }
                return (T)convertedArray;
            }
        }
        return (T)ParcelCommons.convertValue(value, type);
    }

    private static <T> Object convertValue(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(type) && value instanceof Number) {
            Number number = (Number)value;
            if (type == Integer.class) {
                return number.intValue();
            }
            if (type == Long.class) {
                return number.longValue();
            }
            if (type == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (type == Double.class) {
                return number.doubleValue();
            }
        }
        if (type.isInstance(value)) {
            return value;
        }
        return type.cast(value);
    }

    public static <T> T getValueAt(T[] array, int index) {
        if (array == null || index < 0 || index >= array.length) {
            return null;
        }
        return array[index];
    }

    private ParcelCommons() {
    }
}

