/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.scheduledtasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ClearEnvelopeResponse;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/enadawca/scheduledtasks/ClearEnvelope/pwe_dynamic_form.js")
public class ClearEnvelope {
    private static final Logger log = LoggerFactory.getLogger(ClearEnvelope.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusenadawca.enadawca.scheduledtasks.ClearEnvelope")).name("plusenadawca.enadawca.scheduledtasks.ClearEnvelope.name")).description("plusenadawca.enadawca.scheduledtasks.ClearEnvelope.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DELETE)).parameter().id("configId").name("plusenadawca.enadawca.scheduledtasks.ClearEnvelope.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("bufferId").name("plusenadawca.enadawca.scheduledtasks.ClearEnvelope.param.bufferId.name").type((Type)Types.INTEGER).optional().create();
    }

    public String execute(@Param String configId, @Param Integer bufferId) {
        try {
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            ClearEnvelopeResponse response = this.enadawcaApi.clearEnvelope(nadawca, bufferId);
            if (!response.isRetval()) {
                return response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n"));
            }
            return "Successfully cleared envelope!";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Error clearing envelope: " + e.getMessage();
        }
    }
}

