/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.datachoosers;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class OriginOffice {
    private static final Logger log = LoggerFactory.getLogger(OriginOffice.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("plusenadawca.enadawca.datachoosers.OriginOffice")).name("plusenadawca.enadawca.datachoosers.OriginOffice.name")).description("plusenadawca.enadawca.datachoosers.OriginOffice.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.LIST)).parameter().id("configId").name("plusenadawca.enadawca.datachoosers.OriginOffice.param.configId.name").type((Type)Types.STRING).create()).mapping().id("id").name("plusenadawca.enadawca.datachoosers.mapping.id").create().mapping().id("name").name("plusenadawca.enadawca.datachoosers.mapping.name").create().mapping().id("description").name("plusenadawca.enadawca.datachoosers.mapping.description").create();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, @Param String configId) throws IOException {
        ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
        List data = this.enadawcaApi.getOriginOfficeList(nadawca).stream().map(originOffice -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", originOffice.getUrzadNadania());
            map.put("name", originOffice.getNazwaWydruk());
            map.put("description", originOffice.getOpis());
            return map;
        }).filter(item -> item.get("name").toString().toLowerCase().contains(queryData.getQuery().toLowerCase()) || item.get("description").toString().toLowerCase().contains(queryData.getQuery().toLowerCase())).collect(Collectors.toList());
        int start = queryData.getPagination().getStart();
        int limit = queryData.getPagination().getLimit();
        int end = Math.min(start + limit, data.size());
        result.setData(data.subList(start, end));
        result.setTotal(data.size());
    }
}

