/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.datachoosers;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class Buffers {
    private static final Logger log = LoggerFactory.getLogger(Buffers.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("plusenadawca.enadawca.datachoosers.Buffers")).name("plusenadawca.enadawca.datachoosers.Buffers.name")).description("plusenadawca.enadawca.datachoosers.Buffers.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.LIST)).parameter().id("configId").name("plusenadawca.enadawca.datachoosers.Buffers.param.configId.name").type((Type)Types.STRING).create()).mapping().id("bufferId").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.bufferId.name").create().mapping().id("bufferName").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.bufferName.name").create().mapping().id("postingDate").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.postingDate.name").create().mapping().id("originOffice").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.originOffice.name").create().mapping().id("active").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.active.name").create().mapping().id("cardId").name("plusenadawca.enadawca.datachoosers.Buffers.mapping.cardId.name").create();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, @Param String configId) throws IOException {
        ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
        List data = this.enadawcaApi.getEnvelopeBufferList(nadawca).getBufor().stream().map(buforType -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bufferId", buforType.getIdBufor());
            map.put("bufferName", buforType.getOpis());
            map.put("postingDate", ParcelCommons.getLocalDate(buforType.getDataNadania()));
            map.put("originOffice", buforType.getUrzadNadania());
            map.put("active", buforType.isActive());
            map.put("cardId", buforType.getIdKarta());
            return map;
        }).filter(item -> item.get("bufferName").toString().toLowerCase().contains(queryData.getQuery().toLowerCase())).collect(Collectors.toList());
        int start = queryData.getPagination().getStart();
        int limit = queryData.getPagination().getLimit();
        int end = Math.min(start + limit, data.size());
        result.setData(data.subList(start, end));
        result.setTotal(data.size());
    }
}

