/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.FormatType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaPoleconaKrajowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/RegisteredDomesticParcel/pwe_dynamic_form.js")
public class RegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(RegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.RegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.RegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            PrzesylkaPoleconaKrajowaType parcel = this.createRegisteredDomesticParcel(valueParams, functionParams);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaPoleconaKrajowaType createRegisteredDomesticParcel(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        PrzesylkaPoleconaKrajowaType przesylkaPoleconaKrajowaType = new PrzesylkaPoleconaKrajowaType();
        ParcelCommons.fillRegisteredShipmentParameters(przesylkaPoleconaKrajowaType, valueParams, functionParams);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("zasadySpecjalne", valueParams, functionParams, String.class), ZasadySpecjalneEnum::valueOf, przesylkaPoleconaKrajowaType::setZasadySpecjalne);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("posteRestante", valueParams, functionParams), przesylkaPoleconaKrajowaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("iloscPotwierdzenOdbioru", valueParams, functionParams, Integer.class), przesylkaPoleconaKrajowaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("kategoria", valueParams, functionParams, String.class), KategoriaType::valueOf, przesylkaPoleconaKrajowaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("format", valueParams, functionParams, String.class), FormatType::valueOf, przesylkaPoleconaKrajowaType::setFormat);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("gabaryt", valueParams, functionParams, String.class), GabarytType::valueOf, przesylkaPoleconaKrajowaType::setGabaryt);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("masa", valueParams, functionParams, Integer.class), przesylkaPoleconaKrajowaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("egzemplarzBiblioteczny", valueParams, functionParams), przesylkaPoleconaKrajowaType::setEgzemplarzBiblioteczny);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("dlaOciemnialych", valueParams, functionParams), przesylkaPoleconaKrajowaType::setDlaOciemnialych);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("miejscowa", valueParams, functionParams), przesylkaPoleconaKrajowaType::setMiejscowa);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("obszarMiasto", valueParams, functionParams), przesylkaPoleconaKrajowaType::setObszarMiasto);
        if (Boolean.TRUE.equals(ParcelCommons.extractValue("epo.podstawowe", valueParams, functionParams))) {
            przesylkaPoleconaKrajowaType.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(ParcelCommons.extractValue("epo.rozszerzone", valueParams, functionParams))) {
            przesylkaPoleconaKrajowaType.setEpo(new EPOExtendedType());
        }
        if (Boolean.TRUE.equals(ParcelCommons.extractValue("egzemplarzBiblioteczny", valueParams, functionParams))) {
            ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("idLibraryForLegalDeposit", valueParams, functionParams), przesylkaPoleconaKrajowaType::setIdLibraryForLegalDeposit);
        }
        return przesylkaPoleconaKrajowaType;
    }
}

