/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracjaCelna2Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PaczkaZagranicznaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobDoreczeniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZwrotType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/InternationalPackage/pwe_dynamic_form.js")
public class InternationalPackage {
    private static final Logger log = LoggerFactory.getLogger(InternationalPackage.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.InternationalPackage")).name("plusenadawca.enadawca.autotasks.InternationalPackage.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT);
        ParameterCommons.addGeneralParameters(builder);
    }

    public void execute(@Param String configId, @Param Integer bufferId, @Param Variable resultShipmentNumber, @Param Variable resultGuidNumber, @PairedParam(key="valueParameter", value="valueVariable") Map<String, Variable> valueParams, @PairedParam(key="functionParameter", value="functionCall") Map<String, FunctionCall> functionParams) throws AcceptanceException {
        try {
            PaczkaZagranicznaType parcel = this.createInternationalPackage(valueParams, functionParams);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), resultShipmentNumber, resultGuidNumber);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PaczkaZagranicznaType createInternationalPackage(Map<String, Variable> valueParams, Map<String, FunctionCall> functionParams) {
        PaczkaZagranicznaType paczkaZagranicznaType = new PaczkaZagranicznaType();
        ParcelCommons.fillRegisteredShipmentParameters(paczkaZagranicznaType, valueParams, functionParams);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("posteRestante", valueParams, functionParams), paczkaZagranicznaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("masa", valueParams, functionParams, Integer.class), paczkaZagranicznaType::setMasa);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("wartosc", valueParams, functionParams, Integer.class), paczkaZagranicznaType::setWartosc);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("kategoria", valueParams, functionParams, String.class), KategoriaType::valueOf, paczkaZagranicznaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> ParcelCommons.extractValue("iloscPotwierdzenOdbioru", valueParams, functionParams, Integer.class), paczkaZagranicznaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> (Boolean)ParcelCommons.extractValue("utrudnionaManipulacja", valueParams, functionParams), paczkaZagranicznaType::setUtrudnionaManipulacja);
        ParcelCommons.setIfNotNull(() -> (String)ParcelCommons.extractValue("sposobNadaniaInterconnect", valueParams, functionParams), paczkaZagranicznaType::setSposobNadaniaInterconnect);
        Optional<ZwrotType> zwrotType = ParcelCommons.fillReturnType(valueParams, functionParams);
        zwrotType.ifPresent(paczkaZagranicznaType::setZwrot);
        Optional<DeklaracjaCelna2Type> deklaracjaCelna2Type = ParcelCommons.fillCustomsDeclarationType(valueParams, functionParams);
        deklaracjaCelna2Type.ifPresent(paczkaZagranicznaType::setDeklaracjaCelna2);
        Optional<SposobDoreczeniaType> sposobDoreczeniaType = ParcelCommons.fillDeliveryModeType(valueParams, functionParams);
        sposobDoreczeniaType.ifPresent(paczkaZagranicznaType::setSposobDoreczenia);
        return paczkaZagranicznaType;
    }
}

