/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.pluginconfigurationmanager.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusenadawca.pluginconfigurationmanager.dtos.ConnectionConfiguration;
import com.suncode.plugin.plusenadawca.pluginconfigurationmanager.services.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigurationFileService configurationFileService;
    private final Plugin plugin;

    @Autowired
    public ConfigurationServiceImpl(ConfigurationFileService configurationFileService, Plugin plugin) {
        this.configurationFileService = configurationFileService;
        this.plugin = plugin;
    }

    public List<String> getConfigurationIds() {
        return this.getConfigurationList();
    }

    @Override
    public ConnectionConfiguration readConfigurationFile(String configId) throws IOException {
        ConnectionConfiguration connectionConfiguration;
        block8: {
            Assert.isTrue((boolean)this.configExist(configId), (String)String.format("Configuration \"%s\" does not exist", configId));
            InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);
            try {
                connectionConfiguration = (ConnectionConfiguration)this.mapper.readValue(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), ConnectionConfiguration.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("PCM configuration error: " + e.getMessage());
                    throw e;
                }
            }
            stream.close();
        }
        return connectionConfiguration;
    }

    @Override
    public boolean isConfigurationEmpty() {
        return this.getConfigurationList().isEmpty();
    }

    @Override
    public String getDefaultConfiguration() {
        return (String)this.getConfigurationList().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No configurations found!"));
    }

    private List<String> getConfigurationList() {
        return Arrays.asList(this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey()));
    }

    private boolean configExist(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

