/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.utils;

import com.suncode.plugin.plusenadawca.enadawca.enums.FormatPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.enums.ParcelType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AdresType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracaCelnaRodzajEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DeklaracjaCelna2Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DokumentTowarzyszacyRodzajEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.DokumentyTowarzyszaceType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ESposobPowiadomieniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ErrorType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PlacowkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PobranieType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PotwierdzenieEDoreczeniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PotwierdzenieOdbioruPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintKindEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaNieRejestrowanaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaRejestrowanaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobDoreczeniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobPobraniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobPrzekazaniaPotwierdzeniaOdbioruPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SposobZwrotuType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SzczegolyZawartosciPrzesylkiZagranicznejType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.UbezpieczenieType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscPocztex2021Type;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscPrzesylkiZagranicznejEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZawartoscSpecjalnaEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZwrotDokumentowPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZwrotType;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;

public class ParcelCommons {
    public static void processShipment(AddShipmentResponseItemType shipmentResponseItem, Parameters parameters) throws AcceptanceException {
        if (!shipmentResponseItem.getError().isEmpty()) {
            throw new AcceptanceException(shipmentResponseItem.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
        }
        Variable resultShipmentNumber = (Variable)parameters.get("resultShipmentNumber", Variable.class);
        resultShipmentNumber.setValue((Object)shipmentResponseItem.getNumerNadania());
        Variable resultGuidNumber = (Variable)parameters.get("resultGuidNumber", Variable.class);
        resultGuidNumber.setValue((Object)shipmentResponseItem.getGuid());
    }

    public static AdresType getAddressType(Parameters parameters, String parameterIdPrefix) {
        AdresType adresType = new AdresType();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "nazwa", String.class), adresType::setNazwa);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "nazwa2", String.class), adresType::setNazwa2);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "ulica", String.class), adresType::setUlica);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "numerDomu", String.class), adresType::setNumerDomu);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "numerLokalu", String.class), adresType::setNumerLokalu);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "miejscowosc", String.class), adresType::setMiejscowosc);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "kodPocztowy", String.class), adresType::setKodPocztowy);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "telefon", String.class), adresType::setTelefon);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "email", String.class), adresType::setEmail);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "mobile", String.class), adresType::setMobile);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get(parameterIdPrefix + "osobaKontaktowa", String.class), adresType::setOsobaKontaktowa);
        return adresType;
    }

    private static <T extends Enum<T>> List<T> filterEnumValues(Class<T> clazz, List<String> filters) {
        return EnumSet.allOf(clazz).stream().filter(t -> filters.contains(t.name())).toList();
    }

    public static List<PrintKindEnum> getPrintTypesForParcel(ParcelType parcelType) {
        List<String> filters = Arrays.stream(parcelType.getPrintTypes()).map(Enum::name).toList();
        return ParcelCommons.filterEnumValues(PrintKindEnum.class, filters);
    }

    public static LocalDate getLocalDate(XMLGregorianCalendar gregorianDate) {
        return new LocalDate((Object)gregorianDate.toGregorianCalendar().getTime());
    }

    public static XMLGregorianCalendar getGregorianCalendarDate(LocalDate date) {
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(date.toString());
    }

    public static XMLGregorianCalendar[] getGregorianCalendarDate(LocalDate[] dates) {
        XMLGregorianCalendar[] gregorianCalendarDates = new XMLGregorianCalendar[dates.length];
        for (int i = 0; i < gregorianCalendarDates.length; ++i) {
            gregorianCalendarDates[i] = ParcelCommons.getGregorianCalendarDate(dates[i]);
        }
        return gregorianCalendarDates;
    }

    public static boolean checkArrayType(Variable ... arrays) {
        return Stream.of(arrays).allMatch(Variable::isArray);
    }

    public static boolean checkEqualArrayLength(Object[] ... arrays) {
        if (arrays.length == 0) {
            return true;
        }
        int targetSize = arrays[0].length;
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].length == targetSize) continue;
            return false;
        }
        return true;
    }

    public static String errorTypeToString(ErrorType error) {
        return String.format("Error! %d: %s", error.getErrorNumber(), error.getErrorDesc());
    }

    public static void createMainShipmentParameters(PrzesylkaType parcel, Parameters parameters) {
        parcel.setGuid(UUID.randomUUID().toString());
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("mpk", String.class), parcel::setMpk);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("pakietGuid", String.class), parcel::setPakietGuid);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("opakowanieGuid", String.class), parcel::setOpakowanieGuid);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("opis", String.class), parcel::setOpis);
        ParcelCommons.setIfNotNull(() -> (LocalDate)parameters.get("planowanaDataNadania", LocalDate.class), ParcelCommons::getGregorianCalendarDate, parcel::setPlanowanaDataNadania);
    }

    public static void createRegisteredShipmentParameters(PrzesylkaRejestrowanaType parcel, Parameters parameters) {
        parcel.setAdres(ParcelCommons.getAddressType(parameters, ""));
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("numerNadania", String.class), parcel::setNumerNadania);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("sygnatura", String.class), parcel::setSygnatura);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("terminSprawy", String.class), parcel::setTerminSprawy);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("rodzaj", String.class), parcel::setRodzaj);
        ParcelCommons.createMainShipmentParameters(parcel, parameters);
    }

    public static void createNonRegisteredShipmentParameters(PrzesylkaNieRejestrowanaType parcel, Parameters parameters) {
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("ilosc", Integer.class), parcel::setIlosc);
        ParcelCommons.createMainShipmentParameters(parcel, parameters);
    }

    public static void createPocztex2021Parameters(Pocztex2021Type parcel, Parameters parameters) {
        parcel.setPobranie(ParcelCommons.getCashOnDeliveryType(parameters));
        parcel.setPotwierdzenieDoreczenia(ParcelCommons.getDeliveryConfirmationType(parameters));
        parcel.setPotwierdzenieOdbioru(ParcelCommons.getReceivingConfirmationType(parameters));
        parcel.setUbezpieczenie(ParcelCommons.getInsuranceType(parameters));
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), parcel::setMasa);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("wartosc", Integer.class), parcel::setWartosc);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("ostroznie", Boolean.class), parcel::setOstroznie);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("ponadGabaryt", Boolean.class), parcel::setPonadgabaryt);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("format", String.class), FormatPocztex2021Type::getValueString, parcel::setFormat);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("numerPrzesylkiKlienta", String.class), parcel::setNumerPrzesylkiKlienta);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zwrotDokumentow", String.class), ZwrotDokumentowPocztex2021Enum::valueOf, parcel::setZwrotDokumentow);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("idDokumentyZwrotneAdresy", Integer.class), parcel::setIdDokumentyZwrotneAdresy);
        if (Boolean.TRUE.equals(parameters.get("epoPodstawowe", Boolean.class))) {
            parcel.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(parameters.get("epoRozszerzone", Boolean.class))) {
            parcel.setEpo(new EPOExtendedType());
        }
        parcel.setAdresDlaZwrotu(ParcelCommons.getAddressType(parameters, "adresDlaZwrotu_"));
        parcel.setZawartosc(ParcelCommons.getPocztex2021ContentType(parameters));
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zasadySpecjalne", String.class), ZasadySpecjalneEnum::valueOf, parcel::setZasadySpecjalne);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("odbiorWSobote", Boolean.class), parcel::setOdbiorWSobote);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("sprawdzenieZawartosciPrzesylkiPrzezOdbiorce", Boolean.class), parcel::setSprawdzenieZawartosciPrzesylkiPrzezOdbiorce);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("doreczenieDoRakWlasnych", Boolean.class), parcel::setDoreczenieDoRakWlasnych);
        ParcelCommons.createRegisteredShipmentParameters(parcel, parameters);
    }

    public static ZawartoscPocztex2021Type getPocztex2021ContentType(Parameters parameters) {
        ZawartoscPocztex2021Type zawartoscPocztex2021Type = new ZawartoscPocztex2021Type();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.get("zawartoscSpecjalna", String.class)))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("zawartoscSpecjalna", String.class), ZawartoscSpecjalnaEnum::valueOf, zawartoscPocztex2021Type::setZawartoscSpecjalna);
        } else {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("zawartoscInna", String.class), zawartoscPocztex2021Type::setZawartoscInna);
        }
        return zawartoscPocztex2021Type;
    }

    public static UbezpieczenieType getInsuranceType(Parameters parameters) {
        UbezpieczenieType ubezpieczenieType = new UbezpieczenieType();
        ubezpieczenieType.setRodzaj("STANDARD");
        ParcelCommons.setIfNotNull(() -> (Float)parameters.get("ubezpieczenieKwota", Float.class), BigDecimal::valueOf, ubezpieczenieType::setKwota);
        return ubezpieczenieType;
    }

    public static PobranieType getCashOnDeliveryType(Parameters parameters) {
        PobranieType pobranieType = new PobranieType();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("sposobPobrania", String.class), SposobPobraniaType::valueOf, pobranieType::setSposobPobrania);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("kwotaPobrania", Integer.class), pobranieType::setKwotaPobrania);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("nrb", String.class), pobranieType::setNrb);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("tytulem", String.class), pobranieType::setTytulem);
        return pobranieType;
    }

    public static ZwrotType getReturnType(Parameters parameters) {
        ZwrotType zwrotType = new ZwrotType();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("sposobZwrotu", String.class), SposobZwrotuType::valueOf, zwrotType::setSposobZwrotu);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("zwrotPoLiczbieDni", Integer.class), zwrotType::setZwrotPoLiczbieDni);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("traktowacJakPorzucona", Boolean.class), zwrotType::setTraktowacJakPorzucona);
        return zwrotType;
    }

    public static SposobDoreczeniaType getDeliveryModeType(Parameters parameters) {
        SposobDoreczeniaType sposobDoreczeniaType = new SposobDoreczeniaType();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("sposobDoreczeniaKod", String.class), sposobDoreczeniaType::setKod);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("identyfikatorPunktuOdbioru", String.class), sposobDoreczeniaType::setIdentyfikatorPunktuOdbioru);
        return sposobDoreczeniaType;
    }

    public static DeklaracjaCelna2Type getCustomsDeclarationType(Parameters parameters) {
        DeklaracjaCelna2Type deklaracjaCelna2Type = new DeklaracjaCelna2Type();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("deklaracjaCelnaRodzaj", String.class), DeklaracaCelnaRodzajEnum::valueOf, deklaracjaCelna2Type::setRodzaj);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zawartoscPrzesylki", String.class), ZawartoscPrzesylkiZagranicznejEnum::valueOf, deklaracjaCelna2Type::setZawartoscPrzesylki);
        ArrayList dokumentyTowarzyszaceTypes = new ArrayList();
        String[] dokumentyTowarzyszaceNumer = (String[])parameters.get("dokumentyTowarzyszaceNumer", String[].class);
        String[] dokumentyTowarzyszaceRodzaj = (String[])parameters.get("dokumentyTowarzyszaceRodzaj", String[].class);
        IntStream.range(0, dokumentyTowarzyszaceNumer.length).forEach(indeks -> {
            DokumentyTowarzyszaceType dokumentyTowarzyszaceType = new DokumentyTowarzyszaceType();
            ParcelCommons.setIfNotNull(() -> dokumentyTowarzyszaceNumer[indeks], dokumentyTowarzyszaceType::setNumer);
            ParcelCommons.setIfNotNull(() -> dokumentyTowarzyszaceRodzaj[indeks], DokumentTowarzyszacyRodzajEnum::valueOf, dokumentyTowarzyszaceType::setRodzaj);
            dokumentyTowarzyszaceTypes.add(dokumentyTowarzyszaceType);
        });
        deklaracjaCelna2Type.getDokumentyTowarzyszace().addAll(dokumentyTowarzyszaceTypes);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("wyjasnienie", String.class), deklaracjaCelna2Type::setWyjasnienie);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("oplatyPocztowe", String.class), deklaracjaCelna2Type::setOplatyPocztowe);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("uwagi", String.class), deklaracjaCelna2Type::setUwagi);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("numerReferencyjnyImportera", String.class), deklaracjaCelna2Type::setNumerReferencyjnyImportera);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("numerTelefonuImportera", String.class), deklaracjaCelna2Type::setNumerTelefonuImportera);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("walutaKodISO", String.class), deklaracjaCelna2Type::setWalutaKodISO);
        ArrayList szczegolyZawartosciPrzesylkiZagranicznejTypes = new ArrayList();
        String[] okreslenieZawartosci = (String[])parameters.get("okreslenieZawartosci", String[].class);
        Integer[] szczegolyZawartosciIlosc = (Integer[])parameters.get("szczegolyZawartosciIlosc", Integer[].class);
        Integer[] masaNetto = (Integer[])parameters.get("masaNetto", Integer[].class);
        Float[] szczegolyZawartosciWartosc = (Float[])parameters.get("szczegolyZawartosciWartosc", Float[].class);
        String[] numerTaryfyHs = (String[])parameters.get("numerTaryfyHs", String[].class);
        String[] krajPochodzeniaKodAlfa2 = (String[])parameters.get("krajPochodzeniaKodAlfa2", String[].class);
        IntStream.range(0, okreslenieZawartosci.length).forEach(indeks -> {
            SzczegolyZawartosciPrzesylkiZagranicznejType szczegolyZawartosciPrzesylkiZagranicznejType = new SzczegolyZawartosciPrzesylkiZagranicznejType();
            ParcelCommons.setIfNotNull(() -> okreslenieZawartosci[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setOkreslenieZawartosci);
            ParcelCommons.setIfNotNull(() -> szczegolyZawartosciIlosc[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setIlosc);
            ParcelCommons.setIfNotNull(() -> masaNetto[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setMasaNetto);
            ParcelCommons.setIfNotNull(() -> szczegolyZawartosciWartosc[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setWartosc);
            ParcelCommons.setIfNotNull(() -> numerTaryfyHs[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setNumerTaryfyHs);
            ParcelCommons.setIfNotNull(() -> krajPochodzeniaKodAlfa2[indeks], szczegolyZawartosciPrzesylkiZagranicznejType::setKrajPochodzeniaKodAlfa2);
            szczegolyZawartosciPrzesylkiZagranicznejTypes.add(szczegolyZawartosciPrzesylkiZagranicznejType);
        });
        deklaracjaCelna2Type.getSzczegolyZawartosciPrzesylki().addAll(szczegolyZawartosciPrzesylkiZagranicznejTypes);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("numerReferencyjnyCelny", String.class), deklaracjaCelna2Type::setNumerReferencyjnyCelny);
        return deklaracjaCelna2Type;
    }

    public static PotwierdzenieEDoreczeniaType getDeliveryConfirmationType(Parameters parameters) {
        PotwierdzenieEDoreczeniaType potwierdzenieEDoreczeniaType = new PotwierdzenieEDoreczeniaType();
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("potwierdzenieDoreczeniaSposob", String.class), ESposobPowiadomieniaType::valueOf, potwierdzenieEDoreczeniaType::setSposob);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("potwierdzenieDoreczeniaKontakt", String.class), potwierdzenieEDoreczeniaType::setKontakt);
        return potwierdzenieEDoreczeniaType;
    }

    public static PotwierdzenieOdbioruPocztex2021Type getReceivingConfirmationType(Parameters parameters) {
        PotwierdzenieOdbioruPocztex2021Type potwierdzenieOdbioruPocztex2021Type = new PotwierdzenieOdbioruPocztex2021Type();
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("potwierdzenieOdbioruIlosc", Integer.class), potwierdzenieOdbioruPocztex2021Type::setIlosc);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("potwierdzenieOdbioruSposob", String.class), SposobPrzekazaniaPotwierdzeniaOdbioruPocztex2021Enum::valueOf, potwierdzenieOdbioruPocztex2021Type::setSposobPotwierdzeniaOdbioru);
        return potwierdzenieOdbioruPocztex2021Type;
    }

    public static <T extends PlacowkaPocztowaType> T castPostOfficeType(PlacowkaPocztowaType source, Class<T> targetClass) {
        try {
            PlacowkaPocztowaType target = (PlacowkaPocztowaType)targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : PlacowkaPocztowaType.class.getDeclaredFields()) {
                field.setAccessible(true);
                field.set(target, field.get(source));
            }
            return (T)target;
        }
        catch (Exception e) {
            throw new RuntimeException("Post Office casting failed", e);
        }
    }

    public static <V> void setIfNotNull(Supplier<V> supplier, Consumer<V> setter) {
        V value = supplier.get();
        if (value != null) {
            setter.accept(value);
        }
    }

    public static <V, R> void setIfNotNull(Supplier<V> supplier, Function<V, R> converter, Consumer<R> setter) {
        V rawValue = supplier.get();
        if (rawValue != null) {
            R value = converter.apply(rawValue);
            setter.accept(value);
        }
    }

    private ParcelCommons() {
    }
}

