/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.servlets;

import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.dtos.DocumentClassDto;
import com.suncode.plugin.plusenadawca.enadawca.enums.ParcelType;
import com.suncode.plugin.plusenadawca.enadawca.services.DocumentService;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintFormatEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintKindEnum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrintMethodEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.search.CountedResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/enadawca"})
public class EnadawcaController {
    private static final Logger log = LoggerFactory.getLogger(EnadawcaController.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;
    @Autowired
    private DocumentService documentService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/originoffice"})
    public ResponseEntity<CountedResult<Map<String, Object>>> getOriginOfficeList(@RequestParam String configId) throws IOException {
        if (StringUtils.isBlank((CharSequence)configId)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
        List<Map> originOfficeList = this.enadawcaApi.getOriginOfficeList(nadawca).stream().map(originOffice -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", originOffice.getUrzadNadania().toString());
            map.put("name", originOffice.getNazwaWydruk());
            map.put("description", originOffice.getOpis());
            return map;
        }).toList();
        return new ResponseEntity((Object)new CountedResult((long)originOfficeList.size(), originOfficeList), (HttpStatusCode)HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/printmethodname"})
    public CountedResult<Map<String, Object>> getPrintMethodName() {
        ArrayList data = new ArrayList();
        for (PrintMethodEnum method : PrintMethodEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", method.value());
            map.put("name", method.name());
            data.add(map);
        }
        return new CountedResult((long)data.size(), data);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/printformatname"})
    public CountedResult<Map<String, Object>> getPrintFormatName() {
        ArrayList data = new ArrayList();
        for (PrintFormatEnum format : PrintFormatEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", format.value());
            map.put("name", format.name());
            data.add(map);
        }
        return new CountedResult((long)data.size(), data);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/printkindname"})
    public CountedResult<Map<String, Object>> getPrintKindName(@RequestParam(required=false) String parcelType) {
        ArrayList data = new ArrayList();
        if (parcelType != null) {
            List<PrintKindEnum> printTypesForParcel = ParcelCommons.getPrintTypesForParcel(ParcelType.from(parcelType));
            for (PrintKindEnum kind : printTypesForParcel) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", kind.value());
                map.put("name", kind.name());
                data.add(map);
            }
        }
        return new CountedResult((long)data.size(), data);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/document/classnames"})
    public CountedResult<DocumentClassDto> getDocumentClassNames(@RequestParam(required=false) String query) {
        return query != null ? this.documentService.getDocumentClasses(query) : this.documentService.getDocumentClasses();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/parceltype"})
    public CountedResult<Map<String, Object>> getParcelTypes() {
        ArrayList data = new ArrayList();
        for (ParcelType type : ParcelType.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", type.name());
            map.put("name", type.getDisplayName());
            data.add(map);
        }
        return new CountedResult((long)data.size(), data);
    }
}

