/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.scheduledtasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SendEnvelopeResponseType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="dist/enadawca/scheduledtasks/SendEnvelope/pwe_dynamic_form.js")
public class SendEnvelope {
    private static final Logger log = LoggerFactory.getLogger(SendEnvelope.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("plusenadawca.enadawca.scheduledtasks.SendEnvelope")).name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.name")).description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.SEND)).parameter().id("configId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("originOfficeId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.originOfficeId.name").description("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.originOfficeId.desc").type((Type)Types.STRING).create()).parameter().id("bufferId").name("plusenadawca.enadawca.scheduledtasks.SendEnvelope.param.bufferId.name").type((Type)Types.INTEGER).optional().create();
    }

    public String execute(@Param String configId, @Param String originOfficeId, @Param Integer bufferId) {
        try {
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            SendEnvelopeResponseType response = this.enadawcaApi.sendEnvelope(nadawca, Integer.valueOf(originOfficeId), bufferId);
            if (!response.getError().isEmpty()) {
                return response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n"));
            }
            return "Successfully sent default envelope!";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Error sending envelope: " + e.getMessage();
        }
    }
}

