/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.FormatType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaPoleconaKrajowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/RegisteredDomesticParcel/pwe_dynamic_form.js")
public class RegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(RegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.AddSingleRegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.AddSingleRegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("zasadySpecjalne").name("plusenadawca.enadawca.autotasks.param.zasadySpecjalne.name").type((Type)Types.STRING).optional().create()).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("iloscPotwierdzenOdbioru").name("plusenadawca.enadawca.autotasks.param.iloscPotwierdzenOdbioru.name").type((Type)Types.INTEGER).optional().create()).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("gabaryt").name("plusenadawca.enadawca.autotasks.param.gabaryt.name").type((Type)Types.STRING).optional().create()).parameter().id("format").name("plusenadawca.enadawca.autotasks.param.format.name").type((Type)Types.STRING).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("egzemplarzBiblioteczny").name("plusenadawca.enadawca.autotasks.param.egzemplarzBiblioteczny.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("dlaOciemnialych").name("plusenadawca.enadawca.autotasks.param.dlaOciemnialych.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("miejscowa").name("plusenadawca.enadawca.autotasks.param.miejscowa.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("obszarMiasto").name("plusenadawca.enadawca.autotasks.param.obszarMiasto.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("idLibraryForLegalDeposit").name("plusenadawca.enadawca.autotasks.param.idLibraryForLegalDeposit.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addEPOParameters(builder);
        ParameterCommons.addRegisteredShipmentParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PrzesylkaPoleconaKrajowaType parcel = this.createRegisteredDomesticParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaPoleconaKrajowaType createRegisteredDomesticParcel(Parameters parameters) {
        PrzesylkaPoleconaKrajowaType przesylkaPoleconaKrajowaType = new PrzesylkaPoleconaKrajowaType();
        ParcelCommons.createRegisteredShipmentParameters(przesylkaPoleconaKrajowaType, parameters);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.get("zasadySpecjalne", String.class)))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("zasadySpecjalne", String.class), ZasadySpecjalneEnum::valueOf, przesylkaPoleconaKrajowaType::setZasadySpecjalne);
        }
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), przesylkaPoleconaKrajowaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("iloscPotwierdzenOdbioru", Integer.class), przesylkaPoleconaKrajowaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, przesylkaPoleconaKrajowaType::setKategoria);
        if (StringUtils.isBlank((CharSequence)((CharSequence)parameters.get("gabaryt", String.class)))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("format", String.class), FormatType::valueOf, przesylkaPoleconaKrajowaType::setFormat);
        } else {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("gabaryt", String.class), GabarytType::valueOf, przesylkaPoleconaKrajowaType::setGabaryt);
        }
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), przesylkaPoleconaKrajowaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("egzemplarzBiblioteczny", Boolean.class), przesylkaPoleconaKrajowaType::setEgzemplarzBiblioteczny);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("dlaOciemnialych", Boolean.class), przesylkaPoleconaKrajowaType::setDlaOciemnialych);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("miejscowa", Boolean.class), przesylkaPoleconaKrajowaType::setMiejscowa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("obszarMiasto", Boolean.class), przesylkaPoleconaKrajowaType::setObszarMiasto);
        if (Boolean.TRUE.equals(parameters.get("epoPodstawowe", Boolean.class))) {
            przesylkaPoleconaKrajowaType.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(parameters.get("epoRozszerzone", Boolean.class))) {
            przesylkaPoleconaKrajowaType.setEpo(new EPOExtendedType());
        }
        if (Boolean.TRUE.equals(parameters.get("egzemplarzBiblioteczny", Boolean.class))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("idLibraryForLegalDeposit", String.class), przesylkaPoleconaKrajowaType::setIdLibraryForLegalDeposit);
        }
        return przesylkaPoleconaKrajowaType;
    }
}

