/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ObszarType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021NaDzisType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/Pocztex2021Today/pwe_dynamic_form.js")
public class Pocztex2021Today {
    private static final Logger log = LoggerFactory.getLogger(Pocztex2021Today.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.Pocztex2021Today")).name("plusenadawca.enadawca.autotasks.Pocztex2021Today.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("odleglosc").name("plusenadawca.enadawca.autotasks.param.odleglosc.name").type((Type)Types.INTEGER).optional().create()).parameter().id("obszar").name("plusenadawca.enadawca.autotasks.param.obszar.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addPocztex2021Parameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Pocztex2021NaDzisType parcel = this.createPocztex2021TodayParcel(nadawca, parameters);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Pocztex2021NaDzisType createPocztex2021TodayParcel(ElektronicznyNadawca nadawca, Parameters parameters) {
        Pocztex2021NaDzisType pocztex2021NaDzisType = new Pocztex2021NaDzisType();
        ParcelCommons.createPocztex2021Parameters(pocztex2021NaDzisType, parameters);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("odleglosc", Integer.class), pocztex2021NaDzisType::setOdleglosc);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("obszar", String.class), ObszarType::valueOf, pocztex2021NaDzisType::setObszar);
        return pocztex2021NaDzisType;
    }
}

