/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GodzinaDoreczeniaPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PlacowkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.Pocztex2021KurierType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PunktNadaniaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PunktOdbioruType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ShipmentChannelPocztex2021Enum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/Pocztex2021Carrier/pwe_dynamic_form.js")
public class Pocztex2021Carrier {
    private static final Logger log = LoggerFactory.getLogger(Pocztex2021Carrier.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.Pocztex2021Carrier")).name("plusenadawca.enadawca.autotasks.Pocztex2021Carrier.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("punktOdbioru").name("plusenadawca.enadawca.autotasks.param.punktOdbioru.name").type((Type)Types.INTEGER).optional().create()).parameter().id("punktNadania").name("plusenadawca.enadawca.autotasks.param.punktNadania.name").type((Type)Types.INTEGER).optional().create()).parameter().id("kopertaPocztex").name("plusenadawca.enadawca.autotasks.param.kopertaPocztex.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("godzinaDoreczenia").name("plusenadawca.enadawca.autotasks.param.godzinaDoreczenia.name").type((Type)Types.STRING).optional().create()).parameter().id("doreczenieWeWskazanymDniu").name("plusenadawca.enadawca.autotasks.param.doreczenieWeWskazanymDniu.name").type((Type)Types.DATE).optional().create()).parameter().id("labelExpirationDate").name("plusenadawca.enadawca.autotasks.param.labelExpirationDate.name").type((Type)Types.DATE).optional().create()).parameter().id("shipmentChannel").name("plusenadawca.enadawca.autotasks.param.shipmentChannel.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addPocztex2021Parameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Pocztex2021KurierType parcel = this.createPocztex2021CarrierParcel(nadawca, parameters);
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Pocztex2021KurierType createPocztex2021CarrierParcel(ElektronicznyNadawca nadawca, Parameters parameters) {
        Pocztex2021KurierType pocztex2021KurierType = new Pocztex2021KurierType();
        ParcelCommons.createPocztex2021Parameters(pocztex2021KurierType, parameters);
        if (parameters.get("punktOdbioru", Integer.class) != null) {
            PlacowkaPocztowaType punktOdbioruPlacowka = this.enadawcaApi.getPlacowkaPocztowa(nadawca, (Integer)parameters.get("punktOdbioru", Integer.class));
            PunktOdbioruType punktOdbioru = ParcelCommons.castPostOfficeType(punktOdbioruPlacowka, PunktOdbioruType.class);
            pocztex2021KurierType.setPunktOdbioru(punktOdbioru);
        }
        if (parameters.get("punktNadania", Integer.class) != null) {
            PlacowkaPocztowaType punktNadaniaPlacowka = this.enadawcaApi.getPlacowkaPocztowa(nadawca, (Integer)parameters.get("punktNadania", Integer.class));
            PunktNadaniaType punktNadania = ParcelCommons.castPostOfficeType(punktNadaniaPlacowka, PunktNadaniaType.class);
            pocztex2021KurierType.setPunktNadania(punktNadania);
        }
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("kopertaPocztex", Boolean.class), pocztex2021KurierType::setKopertaPocztex);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("godzinaDoreczenia", String.class), GodzinaDoreczeniaPocztex2021Enum::valueOf, pocztex2021KurierType::setGodzinaDoreczenia);
        ParcelCommons.setIfNotNull(() -> (LocalDate)parameters.get("doreczenieWeWskazanymDniu", LocalDate.class), ParcelCommons::getGregorianCalendarDate, pocztex2021KurierType::setDoreczenieWeWskazanymDniu);
        ParcelCommons.setIfNotNull(() -> (LocalDate)parameters.get("labelExpirationDate", LocalDate.class), ParcelCommons::getGregorianCalendarDate, pocztex2021KurierType::setLabelExpirationDate);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("shipmentChannel", String.class), ShipmentChannelPocztex2021Enum::valueOf, pocztex2021KurierType::setShipmentChannel);
        return pocztex2021KurierType;
    }
}

