/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.FormatType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaNierejestrowanaKrajowaType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/NonRegisteredDomesticParcel/pwe_dynamic_form.js")
public class NonRegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(NonRegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.NonRegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.NonRegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("format").name("plusenadawca.enadawca.autotasks.param.format.name").type((Type)Types.STRING).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("egzemplarzBiblioteczny").name("plusenadawca.enadawca.autotasks.param.egzemplarzBiblioteczny.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("idLibraryForLegalDeposit").name("plusenadawca.enadawca.autotasks.param.idLibraryForLegalDeposit.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addNonRegisteredShipmentParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PrzesylkaNierejestrowanaKrajowaType parcel = this.createNonRegisteredDomesticParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaNierejestrowanaKrajowaType createNonRegisteredDomesticParcel(Parameters parameters) {
        PrzesylkaNierejestrowanaKrajowaType przesylkaNierejestrowanaKrajowaType = new PrzesylkaNierejestrowanaKrajowaType();
        ParcelCommons.createNonRegisteredShipmentParameters(przesylkaNierejestrowanaKrajowaType, parameters);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, przesylkaNierejestrowanaKrajowaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("format", String.class), FormatType::valueOf, przesylkaNierejestrowanaKrajowaType::setFormat);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), przesylkaNierejestrowanaKrajowaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("egzemplarzBiblioteczny", Boolean.class), przesylkaNierejestrowanaKrajowaType::setEgzemplarzBiblioteczny);
        if (Boolean.TRUE.equals(parameters.get("egzemplarzBiblioteczny", Boolean.class))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("idLibraryForLegalDeposit", String.class), przesylkaNierejestrowanaKrajowaType::setIdLibraryForLegalDeposit);
        }
        return przesylkaNierejestrowanaKrajowaType;
    }
}

