/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaZagranicznaType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/InternationalParcel/pwe_dynamic_form.js")
public class InternationalParcel {
    private static final Logger log = LoggerFactory.getLogger(InternationalParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.InternationalParcel")).name("plusenadawca.enadawca.autotasks.InternationalParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("ekspres").name("plusenadawca.enadawca.autotasks.param.ekspres.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("kraj").name("plusenadawca.enadawca.autotasks.param.kraj.name").type((Type)Types.STRING).optional().create()).parameter().id("zawartosc").name("plusenadawca.enadawca.autotasks.param.zawartosc.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addNonRegisteredShipmentParameters(builder);
        ParameterCommons.addAddressParameters(builder, "adresat_");
        ParameterCommons.addAddressParameters(builder, "nadawca_");
        ParameterCommons.addCustomsDeclarationParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PrzesylkaZagranicznaType parcel = this.createInternationalParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaZagranicznaType createInternationalParcel(Parameters parameters) {
        PrzesylkaZagranicznaType przesylkaZagranicznaType = new PrzesylkaZagranicznaType();
        ParcelCommons.createNonRegisteredShipmentParameters(przesylkaZagranicznaType, parameters);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), przesylkaZagranicznaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, przesylkaZagranicznaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), przesylkaZagranicznaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("ekspres", Boolean.class), przesylkaZagranicznaType::setEkspres);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kraj", String.class), przesylkaZagranicznaType::setKraj);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zawartosc", String.class), przesylkaZagranicznaType::setZawartosc);
        przesylkaZagranicznaType.setAdres(ParcelCommons.getAddressType(parameters, "adresat_"));
        przesylkaZagranicznaType.setNadawca(ParcelCommons.getAddressType(parameters, "nadawca_"));
        przesylkaZagranicznaType.setDeklaracjaCelna2(ParcelCommons.getCustomsDeclarationType(parameters));
        return przesylkaZagranicznaType;
    }
}

