/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PaczkaZagranicznaType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/InternationalPackage/pwe_dynamic_form.js")
public class InternationalPackage {
    private static final Logger log = LoggerFactory.getLogger(InternationalPackage.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.InternationalPackage")).name("plusenadawca.enadawca.autotasks.InternationalPackage.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("wartosc").name("plusenadawca.enadawca.autotasks.param.wartosc.name").type((Type)Types.INTEGER).optional().create()).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("iloscPotwierdzenOdbioru").name("plusenadawca.enadawca.autotasks.param.iloscPotwierdzenOdbioru.name").type((Type)Types.INTEGER).optional().create()).parameter().id("utrudnionaManipulacja").name("plusenadawca.enadawca.autotasks.param.utrudnionaManipulacja.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("sposobNadaniaInterconnect").name("plusenadawca.enadawca.autotasks.param.sposobNadaniaInterconnect.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addRegisteredShipmentParameters(builder);
        ParameterCommons.addCustomsDeclarationParameters(builder);
        ParameterCommons.addReturnParameters(builder);
        ParameterCommons.addDeliveryModeParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PaczkaZagranicznaType parcel = this.createInternationalPackage(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PaczkaZagranicznaType createInternationalPackage(Parameters parameters) {
        PaczkaZagranicznaType paczkaZagranicznaType = new PaczkaZagranicznaType();
        ParcelCommons.createRegisteredShipmentParameters(paczkaZagranicznaType, parameters);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), paczkaZagranicznaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), paczkaZagranicznaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("wartosc", Integer.class), paczkaZagranicznaType::setWartosc);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, paczkaZagranicznaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("iloscPotwierdzenOdbioru", Integer.class), paczkaZagranicznaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("utrudnionaManipulacja", Boolean.class), paczkaZagranicznaType::setUtrudnionaManipulacja);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("sposobNadaniaInterconnect", String.class), paczkaZagranicznaType::setSposobNadaniaInterconnect);
        paczkaZagranicznaType.setZwrot(ParcelCommons.getReturnType(parameters));
        paczkaZagranicznaType.setDeklaracjaCelna2(ParcelCommons.getCustomsDeclarationType(parameters));
        paczkaZagranicznaType.setSposobDoreczenia(ParcelCommons.getDeliveryModeType(parameters));
        return paczkaZagranicznaType;
    }
}

