/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaZadeklarowanaWartoscZagranicznaType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/InternationalDeclaredValueParcel/pwe_dynamic_form.js")
public class InternationalDeclaredValueParcel {
    private static final Logger log = LoggerFactory.getLogger(InternationalDeclaredValueParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.InternationalDeclaredValueParcel")).name("plusenadawca.enadawca.autotasks.InternationalDeclaredValueParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("iloscPotwierdzenOdbioru").name("plusenadawca.enadawca.autotasks.param.iloscPotwierdzenOdbioru.name").type((Type)Types.INTEGER).optional().create()).parameter().id("wartosc").name("plusenadawca.enadawca.autotasks.param.wartosc.name").type((Type)Types.INTEGER).optional().create()).parameter().id("zawartosc").name("plusenadawca.enadawca.autotasks.param.zawartosc.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addRegisteredShipmentParameters(builder);
        ParameterCommons.addCustomsDeclarationParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PrzesylkaZadeklarowanaWartoscZagranicznaType parcel = this.createInternationalDeclaredValueParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaZadeklarowanaWartoscZagranicznaType createInternationalDeclaredValueParcel(Parameters parameters) {
        PrzesylkaZadeklarowanaWartoscZagranicznaType przesylkaZadeklarowanaWartoscZagranicznaType = new PrzesylkaZadeklarowanaWartoscZagranicznaType();
        ParcelCommons.createRegisteredShipmentParameters(przesylkaZadeklarowanaWartoscZagranicznaType, parameters);
        przesylkaZadeklarowanaWartoscZagranicznaType.setDeklaracjaCelna2(ParcelCommons.getCustomsDeclarationType(parameters));
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), przesylkaZadeklarowanaWartoscZagranicznaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("iloscPotwierdzenOdbioru", Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("wartosc", Integer.class), przesylkaZadeklarowanaWartoscZagranicznaType::setWartosc);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zawartosc", String.class), przesylkaZadeklarowanaWartoscZagranicznaType::setZawartosc);
        return przesylkaZadeklarowanaWartoscZagranicznaType;
    }
}

