/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PaczkaPocztowaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/DomesticPackage/pwe_dynamic_form.js")
public class DomesticPackage {
    private static final Logger log = LoggerFactory.getLogger(DomesticPackage.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.DomesticPackage")).name("plusenadawca.enadawca.autotasks.DomesticPackage.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("iloscPotwierdzenOdbioru").name("plusenadawca.enadawca.autotasks.param.iloscPotwierdzenOdbioru.name").type((Type)Types.INTEGER).optional().create()).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("gabaryt").name("plusenadawca.enadawca.autotasks.param.gabaryt.name").type((Type)Types.STRING).optional().create()).parameter().id("wartosc").name("plusenadawca.enadawca.autotasks.param.wartosc.name").type((Type)Types.INTEGER).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("egzemplarzBiblioteczny").name("plusenadawca.enadawca.autotasks.param.egzemplarzBiblioteczny.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("dlaOciemnialych").name("plusenadawca.enadawca.autotasks.param.dlaOciemnialych.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("zasadySpecjalne").name("plusenadawca.enadawca.autotasks.param.zasadySpecjalne.name").type((Type)Types.STRING).optional().create()).parameter().id("idLibraryForLegalDeposit").name("plusenadawca.enadawca.autotasks.param.idLibraryForLegalDeposit.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addEPOParameters(builder);
        ParameterCommons.addInsuranceParameters(builder);
        ParameterCommons.addRegisteredShipmentParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PaczkaPocztowaType parcel = this.createDomesticPackage(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PaczkaPocztowaType createDomesticPackage(Parameters parameters) {
        PaczkaPocztowaType paczkaPocztowaType = new PaczkaPocztowaType();
        ParcelCommons.createRegisteredShipmentParameters(paczkaPocztowaType, parameters);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), paczkaPocztowaType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("iloscPotwierdzenOdbioru", Integer.class), paczkaPocztowaType::setIloscPotwierdzenOdbioru);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, paczkaPocztowaType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("gabaryt", String.class), GabarytType::valueOf, paczkaPocztowaType::setGabaryt);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("wartosc", Integer.class), paczkaPocztowaType::setWartosc);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), paczkaPocztowaType::setMasa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("egzemplarzBiblioteczny", Boolean.class), paczkaPocztowaType::setEgzemplarzBiblioteczny);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("dlaOciemnialych", Boolean.class), paczkaPocztowaType::setDlaOciemnialych);
        if (Boolean.TRUE.equals(parameters.get("epoPodstawowe", Boolean.class))) {
            paczkaPocztowaType.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(parameters.get("epoRozszerzone", Boolean.class))) {
            paczkaPocztowaType.setEpo(new EPOExtendedType());
        }
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zasadySpecjalne", String.class), ZasadySpecjalneEnum::valueOf, paczkaPocztowaType::setZasadySpecjalne);
        paczkaPocztowaType.setUbezpieczenie(ParcelCommons.getInsuranceType(parameters));
        if (Boolean.TRUE.equals(parameters.get("egzemplarzBiblioteczny", Boolean.class))) {
            ParcelCommons.setIfNotNull(() -> (String)parameters.get("idLibraryForLegalDeposit", String.class), paczkaPocztowaType::setIdLibraryForLegalDeposit);
        }
        return paczkaPocztowaType;
    }
}

