/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOExtendedType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.EPOSimpleType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.PrzesylkaFirmowaPoleconaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ZasadySpecjalneEnum;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/CommercialRegisteredDomesticParcel/pwe_dynamic_form.js")
public class CommercialRegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(CommercialRegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.CommercialRegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.CommercialRegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("miejscowa").name("plusenadawca.enadawca.autotasks.param.miejscowa.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("obszarMiasto").name("plusenadawca.enadawca.autotasks.param.obszarMiasto.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("gabaryt").name("plusenadawca.enadawca.autotasks.param.gabaryt.name").type((Type)Types.STRING).optional().create()).parameter().id("zasadySpecjalne").name("plusenadawca.enadawca.autotasks.param.zasadySpecjalne.name").type((Type)Types.STRING).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addRegisteredShipmentParameters(builder);
        ParameterCommons.addEPOParameters(builder);
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            PrzesylkaFirmowaPoleconaType parcel = this.createCommercialRegisteredDomesticParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private PrzesylkaFirmowaPoleconaType createCommercialRegisteredDomesticParcel(Parameters parameters) {
        PrzesylkaFirmowaPoleconaType przesylkaFirmowaPoleconaType = new PrzesylkaFirmowaPoleconaType();
        ParcelCommons.createRegisteredShipmentParameters(przesylkaFirmowaPoleconaType, parameters);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("miejscowa", Boolean.class), przesylkaFirmowaPoleconaType::setMiejscowa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("obszarMiasto", Boolean.class), przesylkaFirmowaPoleconaType::setObszarMiasto);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("gabaryt", String.class), GabarytType::valueOf, przesylkaFirmowaPoleconaType::setGabaryt);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("zasadySpecjalne", String.class), ZasadySpecjalneEnum::valueOf, przesylkaFirmowaPoleconaType::setZasadySpecjalne);
        if (Boolean.TRUE.equals(parameters.get("epoPodstawowe", Boolean.class))) {
            przesylkaFirmowaPoleconaType.setEpo(new EPOSimpleType());
        } else if (Boolean.TRUE.equals(parameters.get("epoRozszerzone", Boolean.class))) {
            przesylkaFirmowaPoleconaType.setEpo(new EPOExtendedType());
        }
        return przesylkaFirmowaPoleconaType;
    }
}

