/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks.shipments;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.AddShipmentResponseItemType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GabarytType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.KategoriaType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ListZwyklyFirmowyType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParameterCommons;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/shipments/CommercialNonRegisteredDomesticParcel/pwe_dynamic_form.js")
public class CommercialNonRegisteredDomesticParcel {
    private static final Logger log = LoggerFactory.getLogger(CommercialNonRegisteredDomesticParcel.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.CommercialNonRegisteredDomesticParcel")).name("plusenadawca.enadawca.autotasks.CommercialNonRegisteredDomesticParcel.name")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("posteRestante").name("plusenadawca.enadawca.autotasks.param.posteRestante.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("masa").name("plusenadawca.enadawca.autotasks.param.masa.name").type((Type)Types.INTEGER).optional().create()).parameter().id("gabaryt").name("plusenadawca.enadawca.autotasks.param.gabaryt.name").type((Type)Types.STRING).optional().create()).parameter().id("kategoria").name("plusenadawca.enadawca.autotasks.param.kategoria.name").type((Type)Types.STRING).optional().create()).parameter().id("egzemplarzBiblioteczny").name("plusenadawca.enadawca.autotasks.param.egzemplarzBiblioteczny.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("dlaOciemnialych").name("plusenadawca.enadawca.autotasks.param.dlaOciemnialych.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("miejscowa").name("plusenadawca.enadawca.autotasks.param.miejscowa.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("obszarMiasto").name("plusenadawca.enadawca.autotasks.param.obszarMiasto.name").type((Type)Types.BOOLEAN).optional().create();
        ParameterCommons.addGeneralParameters(builder);
        ParameterCommons.addNonRegisteredShipmentParameters(builder);
        ParameterCommons.addAddressParameters(builder, "");
    }

    public void execute(Parameters parameters) throws AcceptanceException {
        try {
            ListZwyklyFirmowyType parcel = this.createCommercialNonRegisteredDomesticParcel(parameters);
            Integer bufferId = (Integer)parameters.get("bufferId", Integer.class);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca((String)parameters.get("configId", String.class));
            Optional<AddShipmentResponseItemType> responseItem = this.enadawcaApi.addShipment(nadawca, parcel, bufferId);
            if (responseItem.isPresent()) {
                ParcelCommons.processShipment(responseItem.get(), parameters);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private ListZwyklyFirmowyType createCommercialNonRegisteredDomesticParcel(Parameters parameters) {
        ListZwyklyFirmowyType listZwyklyFirmowyType = new ListZwyklyFirmowyType();
        ParcelCommons.createNonRegisteredShipmentParameters(listZwyklyFirmowyType, parameters);
        listZwyklyFirmowyType.setAdres(ParcelCommons.getAddressType(parameters, ""));
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("posteRestante", Boolean.class), listZwyklyFirmowyType::setPosteRestante);
        ParcelCommons.setIfNotNull(() -> (Integer)parameters.get("masa", Integer.class), listZwyklyFirmowyType::setMasa);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("gabaryt", String.class), GabarytType::valueOf, listZwyklyFirmowyType::setGabaryt);
        ParcelCommons.setIfNotNull(() -> (String)parameters.get("kategoria", String.class), KategoriaType::valueOf, listZwyklyFirmowyType::setKategoria);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("miejscowa", Boolean.class), listZwyklyFirmowyType::setMiejscowa);
        ParcelCommons.setIfNotNull(() -> (Boolean)parameters.get("obszarMiasto", Boolean.class), listZwyklyFirmowyType::setObszarMiasto);
        return listZwyklyFirmowyType;
    }
}

