/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.BuforType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.UpdateEnvelopeBuforResponse;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/UpdateEnvelopeBuffer/pwe_dynamic_form.js")
public class UpdateEnvelopeBuffer {
    private static final Logger log = LoggerFactory.getLogger(UpdateEnvelopeBuffer.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer")).name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.name")).description("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.DELETE)).parameter().id("configId").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("bufferId").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.bufferId.name").type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("bufferName").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.bufferName.name").type((Type)Types.STRING_ARRAY).arrayMinLength(1).create()).parameter().id("postingDate").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.postingDate.name").type((Type)Types.DATE_ARRAY).arrayMinLength(1).create()).parameter().id("originOfficeId").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.originOfficeId.name").type((Type)Types.INTEGER_ARRAY).arrayMinLength(1).create()).parameter().id("active").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.active.name").type((Type)Types.BOOLEAN_ARRAY).arrayMinLength(1).create()).parameter().id("updateItemsPostingDate").name("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.updateItemsPostingDate.name").description("plusenadawca.enadawca.autotasks.UpdateEnvelopeBuffer.param.updateItemsPostingDate.desc").type((Type)Types.BOOLEAN_ARRAY).arrayMinLength(1).create();
    }

    public void execute(@Param String configId, @Param Integer[] bufferId, @Param String[] bufferName, @Param LocalDate[] postingDate, @Param Integer[] originOfficeId, @Param Boolean[] active, @Param Boolean[] updateItemsPostingDate) throws AcceptanceException {
        try {
            XMLGregorianCalendar[] gregorianDates = ParcelCommons.getGregorianCalendarDate(postingDate);
            List<BuforType> buffers = this.enadawcaApi.prepareBuffers(bufferId, bufferName, gregorianDates, originOfficeId, active, updateItemsPostingDate);
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            UpdateEnvelopeBuforResponse response = this.enadawcaApi.updateEnvelopeBuffer(nadawca, buffers);
            if (!response.getError().isEmpty()) {
                throw new AcceptanceException(response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

