/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.SendEnvelopeResponseType;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/SendEnvelope/pwe_dynamic_form.js")
public class SendEnvelope {
    private static final Logger log = LoggerFactory.getLogger(SendEnvelope.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.SendEnvelope")).name("plusenadawca.enadawca.autotasks.SendEnvelope.name")).description("plusenadawca.enadawca.autotasks.SendEnvelope.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.SEND)).parameter().id("configId").name("plusenadawca.enadawca.autotasks.SendEnvelope.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("originOfficeId").name("plusenadawca.enadawca.autotasks.SendEnvelope.param.originOfficeId.name").description("plusenadawca.enadawca.autotasks.SendEnvelope.param.originOfficeId.desc").type((Type)Types.STRING).create()).parameter().id("bufferId").name("plusenadawca.enadawca.autotasks.SendEnvelope.param.bufferId.name").description("plusenadawca.enadawca.autotasks.SendEnvelope.param.bufferId.desc").type((Type)Types.INTEGER).optional().create();
    }

    public void execute(@Param String configId, @Param String originOfficeId, @Param Integer bufferId) throws AcceptanceException {
        try {
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            SendEnvelopeResponseType response = this.enadawcaApi.sendEnvelope(nadawca, Integer.valueOf(originOfficeId), bufferId);
            if (!response.getError().isEmpty()) {
                throw new AcceptanceException(response.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

