/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusenadawca.enadawca.autotasks;

import com.suncode.plugin.plusenadawca.Categories;
import com.suncode.plugin.plusenadawca.enadawca.Enadawca;
import com.suncode.plugin.plusenadawca.enadawca.services.EnadawcaApi;
import com.suncode.plugin.plusenadawca.enadawca.stubs.BuforType;
import com.suncode.plugin.plusenadawca.enadawca.stubs.ElektronicznyNadawca;
import com.suncode.plugin.plusenadawca.enadawca.stubs.GetEnvelopeBuforListResponse;
import com.suncode.plugin.plusenadawca.enadawca.utils.ParcelCommons;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/enadawca/autotasks/GetEnvelopeBufferList/pwe_dynamic_form.js")
public class GetEnvelopeBufferList {
    private static final Logger log = LoggerFactory.getLogger(GetEnvelopeBufferList.class);
    @Autowired
    private Enadawca enadawca;
    @Autowired
    private EnadawcaApi enadawcaApi;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList")).name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.name")).description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.desc")).category(new Category[]{Categories.ENADAWCA})).icon((Icon)DivanteIcon.LIST)).parameter().id("configId").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.configId.name").type((Type)Types.STRING).optional().create()).parameter().id("bufferIdVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.bufferIdVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.bufferIdVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("bufferNameVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.bufferNameVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.bufferNameVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("postingDateVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.postingDateVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.postingDateVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("originOfficeIdVariable").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.originOfficeIdVariable.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.originOfficeIdVariable.desc").type((Type)Types.VARIABLE).create()).parameter().id("activeVariableId").name("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.activeVariableId.name").description("plusenadawca.enadawca.autotasks.GetEnvelopeBufferList.param.activeVariableId.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String configId, @Param Variable bufferIdVariable, @Param Variable bufferNameVariable, @Param Variable postingDateVariable, @Param Variable originOfficeIdVariable, @Param Variable activeVariableId) throws AcceptanceException {
        try {
            if (!ParcelCommons.checkArrayType(bufferIdVariable, bufferNameVariable, postingDateVariable, originOfficeIdVariable, activeVariableId)) {
                throw new AcceptanceException("Expecting array type variables!");
            }
            ElektronicznyNadawca nadawca = this.enadawca.getEnadawca(configId);
            GetEnvelopeBuforListResponse envelopeBufferList = this.enadawcaApi.getEnvelopeBufferList(nadawca);
            if (!envelopeBufferList.getError().isEmpty()) {
                throw new AcceptanceException(envelopeBufferList.getError().stream().map(ParcelCommons::errorTypeToString).collect(Collectors.joining("\n")));
            }
            List<BuforType> buffers = envelopeBufferList.getBufor();
            Integer[] bufferIdArray = new Integer[buffers.size()];
            LocalDate[] postingDateArray = new LocalDate[buffers.size()];
            Integer[] originOfficeIdArray = new Integer[buffers.size()];
            String[] bufferNameArray = new String[buffers.size()];
            String[] activeArray = new String[buffers.size()];
            for (int i = 0; i < buffers.size(); ++i) {
                BuforType buffer = buffers.get(i);
                bufferIdArray[i] = buffer.getIdBufor();
                originOfficeIdArray[i] = buffer.getUrzadNadania();
                postingDateArray[i] = ParcelCommons.getLocalDate(buffer.getDataNadania());
                bufferNameArray[i] = buffer.getOpis();
                activeArray[i] = buffer.isActive().toString();
            }
            bufferIdVariable.setValue((Object)bufferIdArray);
            originOfficeIdVariable.setValue((Object)originOfficeIdArray);
            postingDateVariable.setValue((Object)postingDateArray);
            bufferNameVariable.setValue((Object)bufferNameArray);
            activeVariableId.setValue((Object)activeArray);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }
}

