﻿window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusedoreczenia.pcm.schema.params.systemType.name",
            help: "plusedoreczenia.pcm.schema.params.systemType.desc",
            model: "systemType",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-edoreczenia/config/systemTypes', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                        },
                        async: false
                    }
                );
                return data
            }
        },
        {
            type: "input",
            inputType: "text",
            label: "plusedoreczenia.pcm.schema.params.eDeliveryAddress.name",
            help: "plusedoreczenia.pcm.schema.params.eDeliveryAddress.desc",
            model: "eDeliveryAddress",
            required: true
        },
        {
            type: "input",
            inputType: "text",
            label: "plusedoreczenia.pcm.schema.params.systemName.name",
            help: "plusedoreczenia.pcm.schema.params.systemName.desc",
            model: "systemName",
            required: true
        },
        {
            type: "input",
            inputType: "password",
            label: "plusedoreczenia.pcm.schema.params.privateKey.name",
            help: "plusedoreczenia.pcm.schema.params.privateKey.desc",
            model: "privateKey",
            required: true
        },
        {
            type: "input",
            inputType: "text",
            label: "plusedoreczenia.pcm.schema.params.testEnvironmentProxyUrl.name",
            help: "plusedoreczenia.pcm.schema.params.testEnvironmentProxyUrl.desc",
            model: "testEnvironmentProxyUrl",
            required: false,
            visible: (model) => checkForSystemType(model, "TEST")
        }
    ]
};

function checkForSystemType(model, systemType) {
    return model && model.systemType === systemType;
}