/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusedoreczenia.db.service;

import com.suncode.plugin.plusedoreczenia.db.dao.SentMessageDao;
import com.suncode.plugin.plusedoreczenia.db.entity.SentMessageEntity;
import com.suncode.plugin.plusedoreczenia.db.service.SentMessageService;
import com.suncode.plugin.plusedoreczenia.dto.Message;
import com.suncode.plugin.plusedoreczenia.dto.MessageAddressData;
import com.suncode.plugin.plusedoreczenia.dto.MessageMetadata;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SentMessageServiceImpl
implements SentMessageService {
    @Autowired
    private SentMessageDao sentMessageDao;

    @Override
    public SentMessageEntity findByProcessId(String processId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(SentMessageEntity.class);
        criteria.add(Restrictions.eq((String)"processId", (Object)processId));
        criteria.addOrder(Order.desc((String)"createdAt"));
        return (SentMessageEntity)this.sentMessageDao.findOne(criteria);
    }

    @Override
    public void save(Message message, String messageTaskId, String processId, String pcmConfigId) {
        MessageMetadata messageMetadata = message.getMessageMetadata();
        MessageAddressData from = messageMetadata != null ? messageMetadata.getFrom() : null;
        List<MessageAddressData> to = messageMetadata != null ? messageMetadata.getTo() : null;
        String recipientEDeliveryAddress = null;
        if (to != null && !to.isEmpty()) {
            recipientEDeliveryAddress = to.get(0).getEDeliveryAddress();
        }
        SentMessageEntity messageEntity = SentMessageEntity.builder().senderEDeliveryAddress(from != null ? from.getEDeliveryAddress() : null).recipientEDeliveryAddress(recipientEDeliveryAddress).threadId(messageMetadata != null ? messageMetadata.getThreadId() : null).textBody(message.getTextBody()).pcmConfigId(pcmConfigId).messageTaskId(messageTaskId).processId(processId).build();
        this.sentMessageDao.save(messageEntity);
    }

    @Override
    public void update(SentMessageEntity sentMessageEntity) {
        this.sentMessageDao.update(sentMessageEntity);
    }
}

